/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.plugins.httpsecuritypolicy;

import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.gateway.engine.policies.AbstractMappedPolicy;
import io.apiman.gateway.engine.policy.IPolicyChain;
import io.apiman.gateway.engine.policy.IPolicyContext;
import io.apiman.plugins.httpsecuritypolicy.beans.ContentSecurityPolicyBean;
import io.apiman.plugins.httpsecuritypolicy.beans.HttpSecurityBean;
import java.util.Map;

public class HttpSecurityPolicy
extends AbstractMappedPolicy<HttpSecurityBean> {
    protected Class<HttpSecurityBean> getConfigurationClass() {
        return HttpSecurityBean.class;
    }

    protected void doApply(ServiceRequest request, IPolicyContext context, HttpSecurityBean config, IPolicyChain<ServiceRequest> chain) {
        chain.doApply((Object)request);
    }

    protected void doApply(ServiceResponse response, IPolicyContext context, HttpSecurityBean config, IPolicyChain<ServiceResponse> chain) {
        this.setSecurityHeaders(config, response.getHeaders());
        chain.doApply((Object)response);
    }

    private void setSecurityHeaders(HttpSecurityBean config, Map<String, String> headers) {
        ContentSecurityPolicyBean policyBean;
        if (config.getHsts().getEnabled().booleanValue()) {
            headers.put("Strict-Transport-Security", config.getHsts().getHeaderValue());
        }
        if (config.getFrameOptions() != HttpSecurityBean.FrameOptions.DISABLED) {
            headers.put("X-Frame-Options", config.getFrameOptions().toString());
        }
        if (config.getXssProtection() != HttpSecurityBean.XssProtection.DISABLED) {
            headers.put("X-XSS-Protection", config.getXssProtection().toString());
        }
        if (config.getContentTypeOptions().booleanValue()) {
            headers.put("X-Content-Type-Options", "nosniff");
        }
        if ((policyBean = config.getContentSecurityPolicy()).getMode() != ContentSecurityPolicyBean.Mode.DISABLED) {
            if (policyBean.getMode() == ContentSecurityPolicyBean.Mode.ENABLED) {
                headers.put("Content-Security-Policy", policyBean.getCsp());
            }
            if (policyBean.getMode() == ContentSecurityPolicyBean.Mode.REPORT_ONLY) {
                headers.put("Content-Security-Policy-Report-Only", policyBean.getCsp());
            }
        }
    }
}

