/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.util.crypt.DataEncryptionContext;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.gateway.engine.beans.ApiEndpoint;
import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.apis.ApiBean;
import io.apiman.manager.api.beans.apis.ApiDefinitionType;
import io.apiman.manager.api.beans.apis.ApiGatewayBean;
import io.apiman.manager.api.beans.apis.ApiPlanBean;
import io.apiman.manager.api.beans.apis.ApiStatus;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.apis.ApiVersionStatusBean;
import io.apiman.manager.api.beans.apis.KeyValueTag;
import io.apiman.manager.api.beans.apis.NewApiBean;
import io.apiman.manager.api.beans.apis.NewApiDefinitionBean;
import io.apiman.manager.api.beans.apis.NewApiVersionBean;
import io.apiman.manager.api.beans.apis.UpdateApiBean;
import io.apiman.manager.api.beans.apis.UpdateApiVersionBean;
import io.apiman.manager.api.beans.apis.dto.ApiBeanDto;
import io.apiman.manager.api.beans.apis.dto.ApiPlanMapper;
import io.apiman.manager.api.beans.apis.dto.ApiPlanOrderDto;
import io.apiman.manager.api.beans.apis.dto.ApiPlanOrderEntryDto;
import io.apiman.manager.api.beans.apis.dto.ApiVersionBeanDto;
import io.apiman.manager.api.beans.apis.dto.ApiVersionMapper;
import io.apiman.manager.api.beans.apis.dto.KeyValueTagDto;
import io.apiman.manager.api.beans.apis.dto.KeyValueTagMapper;
import io.apiman.manager.api.beans.apis.dto.UpdateApiPlanDto;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.audit.data.EntityUpdatedData;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanStatus;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.policies.NewPolicyBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyChainBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.policies.UpdatePolicyBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiPlanSummaryBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ApiVersionEndpointSummaryBean;
import io.apiman.manager.api.beans.summary.ApiVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.GatewaySummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.beans.summary.mappers.ApiMapper;
import io.apiman.manager.api.core.IApiValidator;
import io.apiman.manager.api.core.IBlobStore;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.gateway.IGatewayLinkFactory;
import io.apiman.manager.api.rest.exceptions.ApiAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.ApiDefinitionNotFoundException;
import io.apiman.manager.api.rest.exceptions.ApiNotFoundException;
import io.apiman.manager.api.rest.exceptions.ApiVersionAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.ApiVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.EntityStillActiveException;
import io.apiman.manager.api.rest.exceptions.GatewayNotFoundException;
import io.apiman.manager.api.rest.exceptions.InvalidApiStatusException;
import io.apiman.manager.api.rest.exceptions.InvalidNameException;
import io.apiman.manager.api.rest.exceptions.InvalidParameterException;
import io.apiman.manager.api.rest.exceptions.InvalidVersionException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.exceptions.PlanNotFoundException;
import io.apiman.manager.api.rest.exceptions.PolicyNotFoundException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.i18n.Messages;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.audit.AuditUtils;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.rest.impl.util.FieldValidator;
import io.apiman.manager.api.rest.impl.util.RestHelper;
import io.apiman.manager.api.schema.SchemaRewriterService;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.OrganizationService;
import io.apiman.manager.api.service.PolicyService;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@ApplicationScoped
@Transactional
@ParametersAreNonnullByDefault
public class ApiService
implements DataAccessUtilMixin {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(ApiService.class);
    private IStorage storage;
    private IStorageQuery query;
    private OrganizationService organizationService;
    private IApiValidator apiValidator;
    private ISecurityContext securityContext;
    private IDataEncrypter encrypter;
    private IGatewayLinkFactory gatewayLinkFactory;
    private PolicyService policyService;
    private IBlobStore blobStore;
    private SchemaRewriterService schemaRewriterService;
    private final ApiVersionMapper apiVersionMapper = ApiVersionMapper.INSTANCE;
    private final ApiMapper apiMapper = ApiMapper.INSTANCE;
    private final ApiPlanMapper apiPlanMapper = ApiPlanMapper.INSTANCE;
    private final KeyValueTagMapper tagMapper = KeyValueTagMapper.INSTANCE;

    @Inject
    public ApiService(IStorage storage, IStorageQuery query, OrganizationService organizationService, IApiValidator apiValidator, ISecurityContext securityContext, IDataEncrypter encrypter, IGatewayLinkFactory gatewayLinkFactory, PolicyService policyService, IBlobStore blobStore, SchemaRewriterService schemaRewriterService) {
        this.storage = storage;
        this.query = query;
        this.organizationService = organizationService;
        this.apiValidator = apiValidator;
        this.securityContext = securityContext;
        this.encrypter = encrypter;
        this.gatewayLinkFactory = gatewayLinkFactory;
        this.policyService = policyService;
        this.blobStore = blobStore;
        this.schemaRewriterService = schemaRewriterService;
    }

    public ApiService() {
    }

    public void deleteApi(String organizationId, String apiId) throws OrganizationNotFoundException, NotAuthorizedException, EntityStillActiveException {
        this.tryAction(() -> {
            ApiBean api = this.getApiFromStorage(organizationId, apiId);
            Iterator apiVersions = this.storage.getAllApiVersions(organizationId, apiId);
            Iterable iterable = () -> apiVersions;
            List apiVersionBeans = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
            List registeredElems = apiVersionBeans.stream().filter(clientVersion -> clientVersion.getStatus() == ApiStatus.Published).limit(5L).collect(Collectors.toList());
            if (!registeredElems.isEmpty()) {
                throw ExceptionFactory.entityStillActiveExceptionApiVersions(registeredElems);
            }
            for (ApiVersionBean apiVersion : apiVersionBeans) {
                apiVersion.setApi(api);
                if (!this.apiVersionHasApiDefinition(apiVersion)) continue;
                this.storage.deleteApiDefinition(apiVersion);
            }
            this.storage.deleteApi(api);
            if (api.getImage() != null) {
                this.blobStore.remove(api.getImage());
            }
            LOGGER.debug("Deleted API: {0}", new Object[]{api.getName()});
        });
    }

    public ApiBeanDto createApi(String organizationId, NewApiBean bean) throws OrganizationNotFoundException, ApiAlreadyExistsException, NotAuthorizedException, InvalidNameException {
        FieldValidator.validateName(bean.getName());
        ApiBean newApi = new ApiBean();
        newApi.setName(bean.getName());
        newApi.setDescription(bean.getDescription());
        newApi.setId(BeanUtils.idFromName((String)bean.getName()));
        newApi.setCreatedOn(new Date());
        newApi.setCreatedBy(this.securityContext.getCurrentUser());
        newApi.setImage(bean.getImage());
        newApi.setTags(this.tagMapper.toEntity(bean.getTags()));
        return this.tryAction(() -> {
            GatewaySummaryBean gateway = this.getSingularGateway();
            OrganizationBean orgBean = this.organizationService.getOrg(organizationId);
            if (this.storage.getApi(orgBean.getId(), newApi.getId()) != null) {
                throw ExceptionFactory.apiAlreadyExistsException((String)bean.getName());
            }
            newApi.setOrganization(orgBean);
            this.storage.createApi(newApi);
            this.storage.createAuditEntry(AuditUtils.apiCreated(newApi, this.securityContext));
            if (bean.getInitialVersion() != null) {
                NewApiVersionBean newApiVersion = new NewApiVersionBean();
                newApiVersion.setEndpoint(bean.getEndpoint());
                newApiVersion.setEndpointType(bean.getEndpointType());
                newApiVersion.setEndpointContentType(bean.getEndpointContentType());
                newApiVersion.setPlans(bean.getPlans());
                newApiVersion.setPublicAPI(bean.getPublicAPI());
                newApiVersion.setParsePayload(bean.getParsePayload());
                newApiVersion.setDisableKeysStrip(bean.getDisableKeysStrip());
                newApiVersion.setVersion(bean.getInitialVersion());
                newApiVersion.setDefinitionUrl(bean.getDefinitionUrl());
                newApiVersion.setDefinitionType(bean.getDefinitionType());
                newApiVersion.setExtendedDescription(bean.getExtendedDescription());
                this.createApiVersionInternal(newApiVersion, newApi, gateway);
            }
            return this.apiMapper.toDto(newApi);
        });
    }

    public ApiBeanDto getApi(String organizationId, String apiId) throws ApiNotFoundException, NotAuthorizedException {
        return this.apiMapper.toDto(this.getApiFromStorage(organizationId, apiId));
    }

    private ApiBean getApiFromStorage(String organizationId, String apiId) throws ApiNotFoundException {
        ApiBean apiBean = this.tryAction(() -> this.storage.getApi(organizationId, apiId));
        if (apiBean == null) {
            throw ExceptionFactory.apiNotFoundException((String)apiId);
        }
        return apiBean;
    }

    public SearchResultsBean<AuditEntryBean> getApiActivity(String organizationId, String apiId, int page, int pageSize) throws ApiNotFoundException, NotAuthorizedException {
        PagingBean paging = PagingBean.create((int)page, (int)pageSize);
        return this.tryAction(() -> this.query.auditEntity(organizationId, apiId, null, ApiBean.class, paging));
    }

    public List<ApiSummaryBean> listApis(String organizationId) throws OrganizationNotFoundException {
        this.organizationService.getOrg(organizationId);
        return this.tryAction(() -> {
            if (this.securityContext.hasPermission(PermissionType.orgView, organizationId)) {
                return this.query.getApisInOrg(organizationId);
            }
            return RestHelper.hideSensitiveDataFromApiSummaryBeanList(this.query.getApisInOrg(organizationId));
        });
    }

    public void updateApi(String organizationId, String apiId, UpdateApiBean bean) throws ApiNotFoundException, NotAuthorizedException {
        this.tryAction(() -> {
            ApiBean apiForUpdate = this.getApiFromStorage(organizationId, apiId);
            EntityUpdatedData auditData = new EntityUpdatedData();
            if (AuditUtils.valueChanged(apiForUpdate.getDescription(), bean.getDescription())) {
                auditData.addChange("description", apiForUpdate.getDescription(), bean.getDescription());
                apiForUpdate.setDescription(bean.getDescription());
            }
            if (AuditUtils.valueChanged(apiForUpdate.getImage(), bean.getImage())) {
                auditData.addChange("image", apiForUpdate.getImage(), bean.getImage());
                if (apiForUpdate.getImage() != null) {
                    this.blobStore.remove(apiForUpdate.getImage());
                }
                apiForUpdate.setImage(bean.getImage());
                if (bean.getImage() != null) {
                    this.blobStore.attachToBlob(bean.getImage());
                }
            }
            if (AuditUtils.valueChanged(this.tagMapper.toDto(apiForUpdate.getTags()), bean.getTags())) {
                apiForUpdate.setTags(this.tagMapper.toEntity(bean.getTags()));
            }
            this.storage.updateApi(apiForUpdate);
            this.storage.createAuditEntry(AuditUtils.apiUpdated(apiForUpdate, auditData, this.securityContext));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ApiVersionBeanDto createApiVersion(String organizationId, String apiId, NewApiVersionBean newApiVersion) throws ApiNotFoundException, NotAuthorizedException, InvalidVersionException, ApiVersionAlreadyExistsException {
        ApiVersionBean newVersion;
        block19: {
            FieldValidator.validateVersion(newApiVersion.getVersion());
            newVersion = this.tryAction(() -> {
                GatewaySummaryBean gateway = this.getSingularGateway();
                ApiBean api = this.getApiFromStorage(organizationId, apiId);
                if (this.storage.getApiVersion(organizationId, apiId, newApiVersion.getVersion()) != null) {
                    throw ExceptionFactory.apiVersionAlreadyExistsException((String)apiId, (String)newApiVersion.getVersion());
                }
                return this.createApiVersionInternal(newApiVersion, api, gateway);
            });
            if (newApiVersion.isClone() && newApiVersion.getCloneVersion() != null) {
                try {
                    ApiVersionBean cloneSource = this.storage.getApiVersion(organizationId, apiId, newApiVersion.getCloneVersion());
                    UpdateApiVersionBean updatedApi = new UpdateApiVersionBean();
                    if (newApiVersion.getEndpoint() == null) {
                        updatedApi.setEndpoint(cloneSource.getEndpoint());
                    }
                    if (newApiVersion.getEndpointType() == null) {
                        updatedApi.setEndpointType(cloneSource.getEndpointType());
                    }
                    if (newApiVersion.getEndpointContentType() == null) {
                        updatedApi.setEndpointContentType(cloneSource.getEndpointContentType());
                    }
                    updatedApi.setEndpointProperties(cloneSource.getEndpointProperties());
                    updatedApi.setGateways(cloneSource.getGateways());
                    if (newApiVersion.getPlans() == null) {
                        ArrayList<ApiPlanBean> sorted = new ArrayList<ApiPlanBean>(cloneSource.getPlans());
                        sorted.sort(Comparator.comparingInt(ApiPlanBean::getOrderIndex));
                        LinkedHashSet plans = ApiVersionMapper.INSTANCE.toDto2(new LinkedHashSet(sorted));
                        updatedApi.setPlans(plans);
                    }
                    if (newApiVersion.getPublicAPI() == null) {
                        updatedApi.setPublicAPI(Boolean.valueOf(cloneSource.isPublicAPI()));
                    }
                    if (newApiVersion.getParsePayload() == null) {
                        updatedApi.setParsePayload(Boolean.valueOf(cloneSource.isParsePayload()));
                    }
                    if (newApiVersion.getExtendedDescription() == null) {
                        updatedApi.setExtendedDescription(cloneSource.getExtendedDescription());
                    }
                    ApiVersionBean updated = this.updateApiVersion(newVersion, updatedApi);
                    if (newApiVersion.getDefinitionUrl() == null) {
                        InputStream definition = null;
                        try {
                            definition = this.getApiDefinition(organizationId, apiId, newApiVersion.getCloneVersion()).getDefinition();
                            this.setApiDefinition(organizationId, apiId, updated.getVersion(), cloneSource.getDefinitionType(), definition, cloneSource.getDefinitionUrl());
                        }
                        catch (ApiDefinitionNotFoundException apiDefinitionNotFoundException) {
                            IOUtils.closeQuietly(definition);
                        }
                        catch (Exception sdnfe) {
                            LOGGER.error("Unable to create response", (Throwable)sdnfe);
                            {
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(definition);
                                    throw throwable;
                                }
                            }
                            IOUtils.closeQuietly((InputStream)definition);
                        }
                        IOUtils.closeQuietly((InputStream)definition);
                    }
                    List<PolicySummaryBean> policies = this.listApiPolicies(organizationId, apiId, newApiVersion.getCloneVersion());
                    for (PolicySummaryBean policySummary : policies) {
                        PolicyBean policy = this.getApiPolicy(organizationId, apiId, newApiVersion.getCloneVersion(), policySummary.getId());
                        NewPolicyBean npb = new NewPolicyBean();
                        npb.setDefinitionId(policy.getDefinition().getId());
                        npb.setConfiguration(policy.getConfiguration());
                        this.createApiPolicy(organizationId, apiId, updated.getVersion(), npb);
                    }
                }
                catch (Exception e) {
                    Exception t;
                    e.printStackTrace();
                    if (e == null) break block19;
                    e = t = e;
                }
            }
        }
        return this.apiVersionMapper.toDto(newVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiVersionBean createApiVersionInternal(NewApiVersionBean bean, ApiBean api, GatewaySummaryBean gateway) throws Exception {
        if (!BeanUtils.isValidVersion((String)bean.getVersion())) {
            throw new StorageException("Invalid/illegal API version: " + bean.getVersion());
        }
        ApiVersionBean newVersion = new ApiVersionBean();
        newVersion.setVersion(bean.getVersion());
        newVersion.setCreatedBy(this.securityContext.getCurrentUser());
        newVersion.setCreatedOn(new Date());
        newVersion.setModifiedBy(this.securityContext.getCurrentUser());
        newVersion.setModifiedOn(new Date());
        newVersion.setStatus(ApiStatus.Created);
        newVersion.setApi(api);
        newVersion.setEndpoint(bean.getEndpoint());
        newVersion.setEndpointType(bean.getEndpointType());
        newVersion.setEndpointContentType(bean.getEndpointContentType());
        newVersion.setDefinitionUrl(bean.getDefinitionUrl());
        newVersion.setExtendedDescription(bean.getExtendedDescription());
        if (bean.getPublicAPI() != null) {
            newVersion.setPublicAPI(bean.getPublicAPI().booleanValue());
        }
        if (bean.getParsePayload() != null) {
            newVersion.setParsePayload(bean.getParsePayload().booleanValue());
        }
        if (bean.getDisableKeysStrip() != null) {
            newVersion.setDisableKeysStrip(bean.getDisableKeysStrip().booleanValue());
        }
        if (bean.getPlans() != null) {
            newVersion.setPlans(bean.getPlans());
        }
        if (bean.getDefinitionType() != null) {
            newVersion.setDefinitionType(bean.getDefinitionType());
        } else {
            newVersion.setDefinitionType(ApiDefinitionType.None);
        }
        if (gateway != null && newVersion.getGateways() == null) {
            newVersion.setGateways(new HashSet());
            ApiGatewayBean sgb = new ApiGatewayBean();
            sgb.setGatewayId(gateway.getId());
            newVersion.getGateways().add(sgb);
        }
        if (this.apiValidator.isReady(newVersion)) {
            newVersion.setStatus(ApiStatus.Ready);
        } else {
            newVersion.setStatus(ApiStatus.Created);
        }
        Set plans = newVersion.getPlans();
        if (plans != null) {
            List copyOf = List.copyOf(plans);
            for (int i = 0; i < copyOf.size(); ++i) {
                ApiPlanBean splanBean = (ApiPlanBean)copyOf.get(i);
                splanBean.setOrderIndex(i);
                String orgId = newVersion.getApi().getOrganization().getId();
                PlanVersionBean pvb = this.storage.getPlanVersion(orgId, splanBean.getPlanId(), splanBean.getVersion());
                if (pvb == null) {
                    throw new StorageException(Messages.i18n.format("PlanVersionDoesNotExist", new Object[]{splanBean.getPlanId(), splanBean.getVersion()}));
                }
                if (pvb.getStatus() == PlanStatus.Locked) continue;
                throw new StorageException(Messages.i18n.format("PlanNotLocked", new Object[]{splanBean.getPlanId(), splanBean.getVersion()}));
            }
        }
        this.storage.createApiVersion(newVersion);
        String definitionUrl = bean.getDefinitionUrl();
        if (definitionUrl != null && !definitionUrl.trim().isBlank()) {
            InputStream definition = null;
            try {
                definition = new URL(definitionUrl).openStream();
                this.storage.updateApiDefinition(newVersion, definition);
            }
            catch (Exception e) {
                try {
                    LOGGER.error((Throwable)e, "Unable to store API definition from: {0}", new Object[]{definitionUrl});
                    newVersion.setDefinitionType(ApiDefinitionType.None);
                    this.storage.updateApiVersion(newVersion);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(definition);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)definition);
            }
            IOUtils.closeQuietly((InputStream)definition);
        }
        this.storage.createAuditEntry(AuditUtils.apiVersionCreated(newVersion, this.securityContext));
        return newVersion;
    }

    public ApiVersionBeanDto getApiVersion(String organizationId, String apiId, String version) throws ApiVersionNotFoundException {
        ApiVersionBean avb = this.tryAction(() -> this.getApiVersionFromStorage(organizationId, apiId, version));
        return this.apiVersionMapper.toDto(avb);
    }

    public ApiVersionStatusBean getApiVersionStatus(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, NotAuthorizedException {
        ApiVersionBean versionBean = this.getApiVersionFromStorage(organizationId, apiId, version);
        List<PolicySummaryBean> policies = this.listApiPolicies(organizationId, apiId, version);
        return this.apiValidator.getStatus(versionBean, policies);
    }

    public ApiDefinitionStream getApiDefinition(String organizationId, String apiId, String version) throws ApiVersionNotFoundException {
        return this.tryAction(() -> {
            ApiVersionBean apiVersion = this.getApiVersionFromStorage(organizationId, apiId, version);
            try (InputStream defStream = this.storage.getApiDefinition(apiVersion);){
                if (defStream == null) {
                    throw ExceptionFactory.apiDefinitionNotFoundException((String)apiId, (String)version);
                }
                if (apiVersion.getStatus() != ApiStatus.Published) {
                    ApiDefinitionStream apiDefinitionStream = new ApiDefinitionStream(apiVersion.getDefinitionType(), defStream);
                    return apiDefinitionStream;
                }
                ApiDefinitionStream apiDefinitionStream = new ApiDefinitionStream(apiVersion.getDefinitionType(), this.schemaRewriterService.rewrite(apiVersion, defStream).asByteSource().openStream());
                return apiDefinitionStream;
            }
        });
    }

    public ApiVersionEndpointSummaryBean getApiVersionEndpointInfo(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, InvalidApiStatusException {
        return this.tryAction(() -> {
            ApiVersionBean apiVersion = this.getApiVersionFromStorage(organizationId, apiId, version);
            if (apiVersion.getStatus() != ApiStatus.Published) {
                throw new InvalidApiStatusException(Messages.i18n.format("ApiNotPublished", new Object[0]));
            }
            return this.getApiVersionEndpointInfoFromStorage(apiVersion, organizationId, apiId, version);
        });
    }

    private ApiVersionEndpointSummaryBean getApiVersionEndpointInfoFromStorage(ApiVersionBean apiVersion, String organizationId, String apiId, String version) throws GatewayNotFoundException, GatewayAuthenticationException, StorageException {
        Set gateways = apiVersion.getGateways();
        if (gateways.isEmpty()) {
            throw new SystemErrorException("No Gateways for published API!");
        }
        GatewayBean gateway = this.storage.getGateway(((ApiGatewayBean)gateways.iterator().next()).getGatewayId());
        if (gateway == null) {
            throw new GatewayNotFoundException();
        }
        LOGGER.debug(String.format("Got endpoint summary: %s", gateway));
        IGatewayLink link = this.gatewayLinkFactory.create(gateway);
        ApiEndpoint endpoint = link.getApiEndpoint(organizationId, apiId, version);
        ApiVersionEndpointSummaryBean rval = new ApiVersionEndpointSummaryBean();
        rval.setManagedEndpoint(endpoint.getEndpoint());
        return rval;
    }

    public SearchResultsBean<AuditEntryBean> getApiVersionActivity(String organizationId, String apiId, String version, int page, int pageSize) throws ApiVersionNotFoundException, NotAuthorizedException {
        PagingBean paging = PagingBean.create((int)page, (int)pageSize);
        return this.tryAction(() -> this.query.auditEntity(organizationId, apiId, version, ApiBean.class, paging));
    }

    public ApiVersionBeanDto updateApiVersion(String organizationId, String apiId, String version, UpdateApiVersionBean update) throws ApiVersionNotFoundException, NotAuthorizedException {
        ApiVersionBean avb = this.getApiVersionFromStorage(organizationId, apiId, version);
        return this.apiVersionMapper.toDto(this.updateApiVersion(avb, update));
    }

    private ApiVersionBean updateApiVersion(ApiVersionBean avb, UpdateApiVersionBean update) throws ApiVersionNotFoundException {
        if (avb.getStatus() == ApiStatus.Published) {
            Set updatedPIV;
            if (avb.isPublicAPI()) {
                return this.updateApiVersionInternal(avb, update);
            }
            LinkedHashSet updatePlans = Optional.ofNullable(update.getPlans()).orElse(new LinkedHashSet());
            if (updatePlans.size() != avb.getPlans().size()) {
                throw new InvalidParameterException("Can not attach or remove plans from an API Version after it has been published");
            }
            Set existingPIV = avb.getPlans().stream().map(PlanIdVersion::new).collect(Collectors.toSet());
            if (!existingPIV.equals(updatedPIV = updatePlans.stream().map(PlanIdVersion::new).collect(Collectors.toSet()))) {
                throw new InvalidParameterException("Plan IDs and versions must not change after publication");
            }
            UpdateApiVersionBean afterPublishUpdate = ApiVersionMapper.INSTANCE.toPublishedUpdateBean(update);
            return this.updateApiVersionInternal(avb, afterPublishUpdate);
        }
        return this.updateApiVersionInternal(avb, update);
    }

    private ApiVersionBean updateApiVersionInternal(ApiVersionBean avb, UpdateApiVersionBean update) throws ApiVersionNotFoundException {
        if (avb.getStatus() == ApiStatus.Retired) {
            throw ExceptionFactory.invalidApiStatusException();
        }
        avb.setModifiedBy(this.securityContext.getCurrentUser());
        avb.setModifiedOn(new Date());
        EntityUpdatedData data = new EntityUpdatedData();
        if (update.getPlans() != null) {
            Set<ApiPlanBean> changes = update.getPlans().stream().map(up -> this.apiPlanMapper.fromDto(up, avb)).collect(Collectors.toSet());
            data.addChange("plans", AuditUtils.asString_ApiPlanBeans(avb.getPlans()), AuditUtils.asString_ApiPlanBeans(changes));
            LinkedHashSet<ApiPlanBean> apb = new LinkedHashSet<ApiPlanBean>();
            int i = 0;
            for (UpdateApiPlanDto apbu : update.getPlans()) {
                ApiPlanBean entity = this.apiPlanMapper.fromDto(apbu, avb);
                entity.setOrderIndex(i);
                apb.add(entity);
                ++i;
            }
            avb.setPlans(apb);
            this.storage.merge((Object)avb);
        }
        if (AuditUtils.valueChanged(avb.getGateways(), update.getGateways())) {
            data.addChange("gateways", AuditUtils.asString_ApiGatewayBeans(avb.getGateways()), AuditUtils.asString_ApiGatewayBeans(update.getGateways()));
            if (avb.getGateways() == null) {
                avb.setGateways(new HashSet());
            }
            avb.getGateways().clear();
            avb.getGateways().addAll(update.getGateways());
        }
        if (AuditUtils.valueChanged(avb.getEndpoint(), update.getEndpoint())) {
            this.validateEndpoint(update.getEndpoint());
            data.addChange("endpoint", avb.getEndpoint(), update.getEndpoint());
            avb.setEndpoint(update.getEndpoint());
        }
        if (AuditUtils.valueChanged(avb.getEndpointType(), update.getEndpointType())) {
            data.addChange("endpointType", (Enum)avb.getEndpointType(), (Enum)update.getEndpointType());
            avb.setEndpointType(update.getEndpointType());
        }
        if (AuditUtils.valueChanged(avb.getEndpointContentType(), update.getEndpointContentType())) {
            data.addChange("endpointContentType", (Enum)avb.getEndpointContentType(), (Enum)update.getEndpointContentType());
            avb.setEndpointContentType(update.getEndpointContentType());
        }
        if (AuditUtils.valueChanged(avb.getEndpointProperties(), update.getEndpointProperties())) {
            if (avb.getEndpointProperties() == null) {
                avb.setEndpointProperties(new HashMap());
            } else {
                avb.getEndpointProperties().clear();
            }
            if (update.getEndpointProperties() != null) {
                avb.getEndpointProperties().putAll(update.getEndpointProperties());
            }
        }
        if (AuditUtils.valueChanged(avb.isPublicAPI(), update.getPublicAPI())) {
            data.addChange("publicAPI", String.valueOf(avb.isPublicAPI()), String.valueOf(update.getPublicAPI()));
            avb.setPublicAPI(update.getPublicAPI().booleanValue());
        }
        if (AuditUtils.valueChanged(avb.isParsePayload(), update.getParsePayload())) {
            data.addChange("parsePayload", String.valueOf(avb.isParsePayload()), String.valueOf(update.getParsePayload()));
            avb.setParsePayload(update.getParsePayload().booleanValue());
        }
        if (AuditUtils.valueChanged(avb.getDisableKeysStrip(), update.getDisableKeysStrip())) {
            data.addChange("disableKeysStrip", String.valueOf(avb.getDisableKeysStrip()), String.valueOf(update.getDisableKeysStrip()));
            avb.setDisableKeysStrip(update.getDisableKeysStrip().booleanValue());
        }
        if (AuditUtils.valueChanged(avb.getExtendedDescription(), update.getExtendedDescription())) {
            data.addChange("extendedDescription", String.valueOf(avb.getExtendedDescription()), String.valueOf(update.getExtendedDescription()));
            avb.setExtendedDescription(update.getExtendedDescription());
        }
        if (AuditUtils.valueChanged(avb.getDiscoverability(), update.getPublicDiscoverability())) {
            data.addChange("discoverability", String.valueOf(avb.getDiscoverability()), String.valueOf(update.getPublicDiscoverability()));
            avb.setDiscoverability(update.getPublicDiscoverability());
        }
        return this.tryAction(() -> {
            GatewaySummaryBean gateway;
            if ((avb.getGateways() == null || avb.getGateways().isEmpty()) && (gateway = this.getSingularGateway()) != null && avb.getGateways() == null) {
                avb.setGateways(new HashSet());
                ApiGatewayBean sgb = new ApiGatewayBean();
                sgb.setGatewayId(gateway.getId());
                avb.getGateways().add(sgb);
            }
            if (avb.getStatus() != ApiStatus.Published) {
                if (this.apiValidator.isReady(avb)) {
                    avb.setStatus(ApiStatus.Ready);
                } else {
                    avb.setStatus(ApiStatus.Created);
                }
            } else if (!this.apiValidator.isReady(avb)) {
                throw ExceptionFactory.invalidApiStatusException();
            }
            this.encryptEndpointProperties(avb);
            Set plans = avb.getPlans();
            if (plans != null) {
                for (ApiPlanBean splanBean : plans) {
                    String orgId = avb.getApi().getOrganization().getId();
                    PlanVersionBean pvb = this.storage.getPlanVersion(orgId, splanBean.getPlanId(), splanBean.getVersion());
                    if (pvb == null) {
                        throw new StorageException(Messages.i18n.format("PlanVersionDoesNotExist", new Object[]{splanBean.getPlanId(), splanBean.getVersion()}));
                    }
                    if (pvb.getStatus() == PlanStatus.Locked) continue;
                    throw new StorageException(Messages.i18n.format("PlanNotLocked", new Object[]{splanBean.getPlanId(), splanBean.getVersion()}));
                }
            }
            this.storage.updateApiVersion(avb);
            this.storage.createAuditEntry(AuditUtils.apiVersionUpdated(avb, data, this.securityContext));
            LOGGER.debug(String.format("Successfully updated API Version: %s", avb));
            this.decryptEndpointProperties(avb);
            return avb;
        });
    }

    public void setApiDefinition(String organizationId, String apiId, String version, ApiDefinitionType definitionType, InputStream data) {
        this.tryAction(() -> this.setApiDefinition(organizationId, apiId, version, definitionType, data, null));
    }

    public void setApiDefinition(String organizationId, String apiId, String version, NewApiDefinitionBean apiDefinition, InputStream data) {
        this.tryAction(() -> this.setApiDefinition(organizationId, apiId, version, apiDefinition.getDefinitionType(), data, apiDefinition.getDefinitionUrl()));
    }

    private void setApiDefinition(String organizationId, String apiId, String version, ApiDefinitionType definitionType, InputStream data, String definitionUrl) throws StorageException {
        ApiVersionBean apiVersion = this.getApiVersionFromStorage(organizationId, apiId, version);
        if (apiVersion.getDefinitionType() != definitionType) {
            apiVersion.setDefinitionType(definitionType);
            this.storage.updateApiVersion(apiVersion);
        }
        if (!(definitionUrl == null || apiVersion.getDefinitionUrl() != null && apiVersion.getDefinitionUrl().equals(definitionUrl))) {
            apiVersion.setDefinitionUrl(definitionUrl);
            this.storage.updateApiVersion(apiVersion);
        }
        this.storage.createAuditEntry(AuditUtils.apiDefinitionUpdated(apiVersion, this.securityContext));
        this.storage.updateApiDefinition(apiVersion, data);
        apiVersion.setModifiedOn(new Date());
        apiVersion.setModifiedBy(this.securityContext.getCurrentUser());
        this.storage.updateApiVersion(apiVersion);
        LOGGER.debug(String.format("Stored API definition %s: %s", apiId, apiVersion));
    }

    public List<ApiVersionSummaryBean> listApiVersions(String organizationId, String apiId) throws ApiNotFoundException {
        this.getApi(organizationId, apiId);
        return this.tryAction(() -> this.query.getApiVersions(organizationId, apiId));
    }

    public List<ApiPlanSummaryBean> getApiVersionPlans(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, NotAuthorizedException {
        this.getApiVersion(organizationId, apiId, version);
        return this.tryAction(() -> this.query.getApiVersionPlans(organizationId, apiId, version));
    }

    public PolicyBean createApiPolicy(String organizationId, String apiId, String version, NewPolicyBean bean) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        ApiVersionBean avb = this.getApiVersionFromStorage(organizationId, apiId, version);
        if (avb.isPublicAPI() ? avb.getStatus() == ApiStatus.Retired : avb.getStatus() == ApiStatus.Published || avb.getStatus() == ApiStatus.Retired) {
            throw ExceptionFactory.invalidApiStatusException();
        }
        return this.tryAction(() -> {
            PolicyBean policy = this.policyService.createPolicy(organizationId, apiId, version, bean, PolicyType.Api);
            LOGGER.debug(String.format("Created API policy %s", avb));
            avb.setModifiedOn(new Date());
            avb.setModifiedBy(this.securityContext.getCurrentUser());
            return policy;
        });
    }

    public PolicyBean getApiPolicy(String organizationId, String apiId, String version, long policyId) throws OrganizationNotFoundException, ApiVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.getApiVersion(organizationId, apiId, version);
        return this.policyService.getPolicy(PolicyType.Api, organizationId, apiId, version, policyId);
    }

    public void updateApiPolicy(String organizationId, String apiId, String version, long policyId, UpdatePolicyBean bean) throws OrganizationNotFoundException, ApiVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        ApiVersionBean avb = this.getApiVersionFromStorage(organizationId, apiId, version);
        this.tryAction(() -> {
            PolicyBean policy = this.storage.getPolicy(PolicyType.Api, organizationId, apiId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException((long)policyId);
            }
            if (AuditUtils.valueChanged(policy.getConfiguration(), bean.getConfiguration())) {
                policy.setConfiguration(bean.getConfiguration());
            }
            policy.setModifiedOn(new Date());
            policy.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.updatePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyUpdated(policy, PolicyType.Api, this.securityContext));
            avb.setModifiedBy(this.securityContext.getCurrentUser());
            avb.setModifiedOn(new Date());
            this.storage.updateApiVersion(avb);
            LOGGER.debug(String.format("Updated API policy %s", policy));
        });
    }

    public void deleteApiPolicy(String organizationId, String apiId, String version, long policyId) throws OrganizationNotFoundException, ApiVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        ApiVersionBean avb = this.getApiVersionFromStorage(organizationId, apiId, version);
        if (avb.isPublicAPI() ? avb.getStatus() == ApiStatus.Retired : avb.getStatus() == ApiStatus.Published || avb.getStatus() == ApiStatus.Retired) {
            throw ExceptionFactory.invalidApiStatusException();
        }
        this.tryAction(() -> {
            PolicyBean policy = this.storage.getPolicy(PolicyType.Api, organizationId, apiId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException((long)policyId);
            }
            this.storage.deletePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyRemoved(policy, PolicyType.Api, this.securityContext));
            avb.setModifiedBy(this.securityContext.getCurrentUser());
            avb.setModifiedOn(new Date());
            this.storage.updateApiVersion(avb);
            LOGGER.debug("Deleted API {0} policy: {1}", new Object[]{apiId, policy});
        });
    }

    public void deleteApiDefinition(String organizationId, String apiId, String version) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        this.tryAction(() -> {
            ApiVersionBean apiVersion = this.getApiVersionFromStorage(organizationId, apiId, version);
            apiVersion.setDefinitionType(ApiDefinitionType.None);
            apiVersion.setModifiedBy(this.securityContext.getCurrentUser());
            apiVersion.setModifiedOn(new Date());
            apiVersion.setDefinition(null);
            this.storage.createAuditEntry(AuditUtils.apiDefinitionDeleted(apiVersion, this.securityContext));
            this.storage.deleteApiDefinition(apiVersion);
            this.storage.updateApiVersion(apiVersion);
            LOGGER.debug("Deleted API {0} definition {1}", new Object[]{apiId, apiVersion});
        });
    }

    public void deleteApiImage(String organizationId, String apiId) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        this.tryAction(() -> {
            ApiBean apiForUpdate = this.getApiFromStorage(organizationId, apiId);
            EntityUpdatedData auditData = new EntityUpdatedData();
            if (apiForUpdate.getImage() != null) {
                this.blobStore.remove(apiForUpdate.getImage());
                apiForUpdate.setImage(null);
                auditData.addChange("image", apiForUpdate.getImage(), null);
            }
            this.storage.updateApi(apiForUpdate);
            this.storage.createAuditEntry(AuditUtils.apiUpdated(apiForUpdate, auditData, this.securityContext));
        });
    }

    public List<PolicySummaryBean> listApiPolicies(String organizationId, String apiId, String version) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        this.getApiVersion(organizationId, apiId, version);
        return this.tryAction(() -> this.query.getPolicies(organizationId, apiId, version, PolicyType.Api));
    }

    public void reorderApiPolicies(String organizationId, String apiId, String version, PolicyChainBean policyChain) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        ApiVersionBean avb = this.getApiVersionFromStorage(organizationId, apiId, version);
        this.tryAction(() -> {
            ArrayList<Long> newOrder = new ArrayList<Long>(policyChain.getPolicies().size());
            for (PolicySummaryBean psb : policyChain.getPolicies()) {
                newOrder.add(psb.getId());
            }
            this.storage.reorderPolicies(PolicyType.Api, organizationId, apiId, version, newOrder);
            this.storage.createAuditEntry(AuditUtils.policiesReordered(avb, PolicyType.Api, this.securityContext));
            avb.setModifiedBy(this.securityContext.getCurrentUser());
            avb.setModifiedOn(new Date());
            this.storage.updateApiVersion(avb);
        });
    }

    public void reorderApiPlans(String organizationId, String apiId, String version, ApiPlanOrderDto apiPlanOrder) {
        ApiVersionBean avb = this.getApiVersionFromStorage(organizationId, apiId, version);
        for (ApiPlanBean apb : avb.getPlans()) {
            ApiPlanOrderEntryDto lookup = new ApiPlanOrderEntryDto().setPlanId(apb.getPlanId()).setApiVersionId(apb.getApiVersion().getId()).setVersion(apb.getVersion());
            ArrayList apiPlanOrderEntryDtos = new ArrayList(apiPlanOrder.getOrder());
            boolean matches = false;
            ApiPlanOrderEntryDto inner = null;
            for (int i = 0; i < apiPlanOrderEntryDtos.size(); ++i) {
                inner = (ApiPlanOrderEntryDto)apiPlanOrderEntryDtos.get(i);
                if (!inner.equals((Object)lookup)) continue;
                apb.setOrderIndex(i);
                matches = true;
                break;
            }
            if (matches || inner == null) continue;
            throw ExceptionFactory.apiPlanNotFoundException((String)apiId, (String)version, (String)inner.getPlanId(), (String)inner.getVersion());
        }
        this.tryAction(() -> this.storage.updateApiVersion(avb));
    }

    public PolicyChainBean getApiPolicyChain(String organizationId, String apiId, String version, String planId) throws ApiVersionNotFoundException, PlanNotFoundException {
        ApiVersionBean avb = this.getApiVersionFromStorage(organizationId, apiId, version);
        return this.tryAction(() -> {
            String planVersion = null;
            Set plans = avb.getPlans();
            if (plans != null) {
                for (ApiPlanBean apiPlanBean : plans) {
                    if (!apiPlanBean.getPlanId().equals(planId)) continue;
                    planVersion = apiPlanBean.getVersion();
                    break;
                }
            }
            if (planVersion == null) {
                throw ExceptionFactory.planNotFoundException((String)planId);
            }
            List<PolicySummaryBean> apiPolicies = RestHelper.hideSensitiveDataFromPolicySummaryBeanList(this.securityContext, this.query.getPolicies(organizationId, apiId, version, PolicyType.Api));
            List<PolicySummaryBean> planPolicies = RestHelper.hideSensitiveDataFromPolicySummaryBeanList(this.securityContext, this.query.getPolicies(organizationId, planId, planVersion, PolicyType.Plan));
            PolicyChainBean chain = new PolicyChainBean();
            chain.getPolicies().addAll(planPolicies);
            chain.getPolicies().addAll(apiPolicies);
            return chain;
        });
    }

    public List<ContractSummaryBean> getApiVersionContracts(String organizationId, String apiId, String version, int page, int pageSize) throws ApiVersionNotFoundException, NotAuthorizedException {
        this.getApiVersion(organizationId, apiId, version);
        int finalPage = Math.max(page, 1);
        int finalPageSize = pageSize == 0 ? 20 : pageSize;
        return this.tryAction(() -> {
            List contracts = this.query.getContracts(organizationId, apiId, version, finalPage, finalPageSize);
            LOGGER.debug(String.format("Got API %s version %s contracts: %s", apiId, version, contracts));
            return contracts;
        });
    }

    private void validateEndpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new InvalidParameterException(Messages.i18n.format("OrganizationResourceImpl.InvalidEndpointURL", new Object[0]));
        }
    }

    private ApiVersionBean getApiVersionFromStorage(String organizationId, String apiId, String version) {
        ApiVersionBean apiVersion = this.tryAction(() -> this.storage.getApiVersion(organizationId, apiId, version));
        if (apiVersion == null) {
            throw ExceptionFactory.apiVersionNotFoundException((String)apiId, (String)version);
        }
        return apiVersion;
    }

    private boolean apiVersionHasApiDefinition(ApiVersionBean apiVersion) throws StorageException {
        return apiVersion.getDefinitionType() != null && apiVersion.getDefinitionType() != ApiDefinitionType.None && this.storage.getApiDefinition(apiVersion) != null;
    }

    private GatewaySummaryBean getSingularGateway() throws StorageException {
        List gateways = this.query.listGateways();
        if (gateways != null && gateways.size() == 1) {
            return (GatewaySummaryBean)gateways.get(0);
        }
        return null;
    }

    public void decryptEndpointProperties(ApiVersionBean versionBean) {
        Map endpointProperties = versionBean.getEndpointProperties();
        if (endpointProperties != null) {
            for (Map.Entry entry : endpointProperties.entrySet()) {
                DataEncryptionContext ctx = new DataEncryptionContext(versionBean.getApi().getOrganization().getId(), versionBean.getApi().getId(), versionBean.getVersion(), DataEncryptionContext.EntityType.Api);
                entry.setValue(this.encrypter.decrypt((String)entry.getValue(), ctx));
            }
        }
    }

    private void encryptEndpointProperties(ApiVersionBean versionBean) {
        Map endpointProperties = versionBean.getEndpointProperties();
        if (endpointProperties != null) {
            for (Map.Entry entry : endpointProperties.entrySet()) {
                DataEncryptionContext ctx = new DataEncryptionContext(versionBean.getApi().getOrganization().getId(), versionBean.getApi().getId(), versionBean.getVersion(), DataEncryptionContext.EntityType.Api);
                entry.setValue(this.encrypter.encrypt((String)entry.getValue(), ctx));
            }
        }
    }

    public void addTag(@NotNull String orgId, @NotNull String apiId, @NotNull KeyValueTagDto tagDto) {
        KeyValueTag kvTag = new KeyValueTag().setKey(tagDto.getKey()).setValue(tagDto.getValue());
        ApiBean api = this.tryAction(() -> this.storage.getApi(orgId, apiId));
        api.addTag(kvTag);
        this.tryAction(() -> this.storage.updateApi(api));
    }

    public void removeTag(@NotNull String orgId, @NotNull String apiId, @NotNull String key) {
        ApiBean api = this.tryAction(() -> this.storage.getApi(orgId, apiId));
        api.removeTagByKey(key);
        this.tryAction(() -> this.storage.updateApi(api));
    }

    private static final class PlanIdVersion {
        public final String id;
        public final String version;

        public PlanIdVersion(ApiPlanBean pvb) {
            this.id = pvb.getPlanId();
            this.version = pvb.getVersion();
        }

        public PlanIdVersion(UpdateApiPlanDto pvb) {
            this.id = pvb.getPlanId();
            this.version = pvb.getVersion();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlanIdVersion that = (PlanIdVersion)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version);
        }
    }

    public static final class ApiDefinitionStream {
        private final ApiDefinitionType definitionType;
        private final InputStream definition;

        public ApiDefinitionStream(ApiDefinitionType definitionType, InputStream definition) {
            this.definitionType = definitionType;
            this.definition = definition;
        }

        public ApiDefinitionType getDefinitionType() {
            return this.definitionType;
        }

        public InputStream getDefinition() {
            return this.definition;
        }
    }
}

