/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.schema;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.io.CharStreams;
import com.google.common.io.FileBackedOutputStream;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.apis.ApiDefinitionType;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLinkFactory;
import io.apiman.manager.api.schema.format.ApiDefinitionProvider;
import io.apiman.manager.api.schema.format.OpenApiProvider;
import io.apiman.manager.api.schema.format.ProviderContext;
import io.apiman.manager.api.schema.format.WsdlRewriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.PolyNull;

public class SchemaRewriterService {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(SchemaRewriterService.class);
    private static final ApiDefinitionProvider PASSTHROUGH_PROVIDER = new NoOpProvider();
    private static final Cache<SchemaCacheKey, FileBackedOutputStream> SCHEMA_CACHE = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).build();
    private static final Map<ApiDefinitionType, ApiDefinitionProvider> SCHEMA_HANDLERS;
    private IStorage storage;
    private IStorageQuery query;
    private IGatewayLinkFactory gatewayLinkFactory;

    @Inject
    public SchemaRewriterService(IStorage storage, IStorageQuery query, IGatewayLinkFactory gatewayLinkFactory) {
        this.storage = storage;
        this.query = query;
        this.gatewayLinkFactory = gatewayLinkFactory;
    }

    public SchemaRewriterService() {
    }

    public FileBackedOutputStream rewrite(ApiVersionBean avb, InputStream is) throws Exception {
        ProviderContext ctx = new ProviderContext(this.storage, this.query, avb, this.gatewayLinkFactory);
        SchemaCacheKey cacheKey = new SchemaCacheKey(ctx.getAvb().getId(), ctx.getAvb().getModifiedOn());
        @PolyNull FileBackedOutputStream cachedEntry = (FileBackedOutputStream)SCHEMA_CACHE.getIfPresent((Object)cacheKey);
        if (cachedEntry != null) {
            return cachedEntry;
        }
        ApiDefinitionProvider handler = SCHEMA_HANDLERS.getOrDefault(avb.getDefinitionType(), PASSTHROUGH_PROVIDER);
        String rewritten = handler.rewrite(ctx, is, avb.getDefinitionType());
        FileBackedOutputStream fbos = new FileBackedOutputStream(Math.toIntExact(262144L));
        fbos.write(rewritten.getBytes(StandardCharsets.UTF_8));
        SCHEMA_CACHE.put((Object)cacheKey, (Object)fbos);
        return fbos;
    }

    static {
        OpenApiProvider swaggerProvider = new OpenApiProvider();
        SCHEMA_HANDLERS = Map.of(ApiDefinitionType.SwaggerJSON, swaggerProvider, ApiDefinitionType.SwaggerYAML, swaggerProvider, ApiDefinitionType.WSDL, new WsdlRewriter());
    }

    private static class SchemaCacheKey {
        private final long apiVersionId;
        private final Date modifiedOn;

        private SchemaCacheKey(long apiVersionId, Date modifiedOn) {
            this.apiVersionId = apiVersionId;
            this.modifiedOn = modifiedOn;
        }

        public long getApiVersionId() {
            return this.apiVersionId;
        }

        public Date getModifiedOn() {
            return this.modifiedOn;
        }

        public String toString() {
            return new StringJoiner(", ", SchemaCacheKey.class.getSimpleName() + "[", "]").add("apiVersionId=" + this.apiVersionId).add("modifiedOn=" + this.modifiedOn).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaCacheKey that = (SchemaCacheKey)o;
            return this.apiVersionId == that.apiVersionId && Objects.equals(this.modifiedOn, that.modifiedOn);
        }

        public int hashCode() {
            return Objects.hash(this.apiVersionId, this.modifiedOn);
        }
    }

    private static final class NoOpProvider
    implements ApiDefinitionProvider {
        private NoOpProvider() {
        }

        @Override
        public String rewrite(ProviderContext providerCtx, InputStream is, ApiDefinitionType apiDefinitionType) throws IOException, StorageException, GatewayAuthenticationException {
            LOGGER.debug("No basepath/hostname rewriter for API Definition Type {0}. Will just read into a string.", new Object[]{apiDefinitionType});
            try (InputStreamReader reader = new InputStreamReader(is);){
                String string = CharStreams.toString((Readable)reader);
                return string;
            }
        }
    }
}

