/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.interceptors;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.download.BlobReference;
import io.apiman.manager.api.rest.IBlobResource;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;

@Provider
@ServerInterceptor
public class BlobResourceInterceptorProvider
implements WriterInterceptor {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(BlobResourceInterceptorProvider.class);

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            this.rewrite(context);
            context.proceed();
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    private void rewrite(WriterInterceptorContext context) throws IllegalAccessException {
        Object rootEntity = context.getEntity();
        List<FieldAndEntity> blobRefs = this.searchRecursively(rootEntity);
        for (FieldAndEntity fieldAndEntity : blobRefs) {
            Field blobRef = fieldAndEntity.field;
            Object entity = fieldAndEntity.entity;
            String existingValue = (String)blobRef.get(entity);
            if (existingValue == null || existingValue.isBlank()) {
                LOGGER.debug("Null or blank @BlobRef {0}@{1}", new Object[]{blobRef.getName(), entity.getClass().getCanonicalName()});
                continue;
            }
            String resolvedRef = UriBuilder.fromResource(IBlobResource.class).path(existingValue).build(new Object[0]).toString();
            LOGGER.debug("Rewriting response POJO field annotated with resolved @BlobReference: {0} -> {1}", new Object[]{existingValue, resolvedRef});
            blobRef.set(entity, resolvedRef);
        }
    }

    private List<FieldAndEntity> searchRecursively(Object root) throws IllegalAccessException {
        ArrayList<FieldAndEntity> results = new ArrayList<FieldAndEntity>();
        HashSet objectsSeen = new HashSet();
        ArrayDeque nodesToSearch = new ArrayDeque();
        this.resolveValue(root).forEach(nodesToSearch::push);
        while (!nodesToSearch.isEmpty()) {
            Object currentNode = nodesToSearch.pop();
            if (this.isCollectionLike(currentNode)) {
                this.resolveValue(currentNode).forEach(nodesToSearch::add);
                continue;
            }
            if (currentNode.getClass().isEnum() || objectsSeen.contains(currentNode)) continue;
            for (Field f : FieldUtils.getAllFields(currentNode.getClass())) {
                Object value;
                boolean isAccessible = f.trySetAccessible();
                if (f.isAnnotationPresent(BlobReference.class) && f.getType().equals(String.class)) {
                    results.add(new FieldAndEntity(f, currentNode));
                }
                if (!isAccessible || this.shouldBeIgnored(f, currentNode) || (value = f.get(currentNode)) == null) continue;
                this.resolveValue(value).filter(Objects::nonNull).forEach(nodesToSearch::push);
            }
            objectsSeen.add(currentNode);
        }
        return results;
    }

    private boolean shouldBeIgnored(Field f, Object currentNode) {
        int modifiers = f.getModifiers();
        return Modifier.isStatic(modifiers) || ClassUtils.isPrimitiveOrWrapper(f.getType()) || f.getType().isAnnotation() || Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers) || Modifier.isTransient(modifiers) || f.isEnumConstant() || !f.canAccess(currentNode) || f.isAnnotationPresent(JsonIgnore.class) || currentNode instanceof StreamingOutput;
    }

    private boolean isCollectionLike(Object obj) {
        return obj instanceof Map || obj instanceof Collection;
    }

    private Stream<Object> resolveValue(Object obj) {
        if (obj == null) {
            return Stream.empty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().stream();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).stream();
        }
        if (obj instanceof Object[]) {
            return Arrays.stream((Object[])obj);
        }
        return Stream.of(obj);
    }

    private static final class FieldAndEntity {
        public Field field;
        public Object entity;

        public FieldAndEntity(Field field, Object entity) {
            this.field = field;
            this.entity = entity;
        }
    }
}

