/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl.util;

import com.google.common.io.FileBackedOutputStream;
import io.apiman.manager.api.rest.impl.util.ContentDisposition;
import io.apiman.manager.api.rest.impl.util.RestArgumentVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jetbrains.annotations.NotNull;

public class MultipartHelper {
    private static final int COPY_BUFF_SIZE_BYTES = 8192;
    private static final int FBOS_THRESHOLD_BYTES = 0x400000;

    public static MultipartUploadHolder getRequiredImage(@NotNull MultipartFormDataInput multipartInput, @NotNull String partName, long sizeLimitBytes) throws IOException {
        InputPart imgPart = MultipartHelper.getRequiredPart(multipartInput, partName, new MediaType("image", "*"));
        MediaType imgMediaType = imgPart.getMediaType();
        ContentDisposition imgContentDisposition = MultipartHelper.getContentDisposition(imgPart);
        String filename = Optional.ofNullable(imgContentDisposition.getFilename()).orElse("");
        FileBackedOutputStream fbos = MultipartHelper.transferToFbos(imgPart, sizeLimitBytes);
        return new MultipartUploadHolder(filename, fbos, imgMediaType);
    }

    public static InputPart getRequiredPart(@NotNull MultipartFormDataInput formDataInput, @NotNull String partName, @NotNull MediaType mediaType) {
        Map formData = formDataInput.getFormDataMap();
        return Optional.ofNullable((List)formData.get(partName)).filter(parts -> !parts.isEmpty()).map(parts -> (InputPart)parts.get(0)).filter(part -> part.getMediaType().isCompatible(mediaType)).orElseThrow(() -> new IllegalArgumentException("Must provide '" + partName + "' with Content-Type: " + mediaType));
    }

    public static ContentDisposition getContentDisposition(@NotNull InputPart part) {
        return Optional.ofNullable((String)part.getHeaders().getFirst((Object)"Content-Disposition")).map(ContentDisposition::parse).orElseThrow(() -> new IllegalArgumentException("Must have Content-Disposition header for part " + part));
    }

    public static FileBackedOutputStream transferToFbos(@NotNull InputPart part, long sizeLimitBytes) throws IOException {
        FileBackedOutputStream fbos = new FileBackedOutputStream(0x400000);
        MultipartHelper.transferData((InputStream)part.getBody(InputStream.class, null), (OutputStream)fbos, sizeLimitBytes);
        return fbos;
    }

    private static void transferData(InputStream is, OutputStream os, long sizeLimitBytes) {
        try (InputStream inputStream = is;){
            int bytesRead;
            byte[] buff = new byte[8192];
            long bytesTransferred = 0L;
            while ((bytesRead = is.read(buff, 0, 8192)) >= 0) {
                os.write(buff, 0, bytesRead);
                if ((bytesTransferred += (long)bytesRead) <= sizeLimitBytes) continue;
                RestArgumentVerifier.checkSizeMax(bytesTransferred, sizeLimitBytes, "Provided file is larger than the limit of " + sizeLimitBytes + "b");
            }
            RestArgumentVerifier.checkArgument(bytesTransferred > 10L, "Provided file too small");
        }
        catch (IOException ioe) {
            IOUtils.closeQuietly((OutputStream)os);
            throw new UncheckedIOException(ioe);
        }
    }

    public static final class MultipartUploadHolder {
        private final String filename;
        private final FileBackedOutputStream fileBackedOutputStream;
        private final MediaType mediaType;

        public MultipartUploadHolder(String filename, FileBackedOutputStream fileBackedOutputStream, MediaType mediaType) {
            this.filename = filename;
            this.fileBackedOutputStream = fileBackedOutputStream;
            this.mediaType = mediaType;
        }

        public String getFilename() {
            return this.filename;
        }

        public FileBackedOutputStream getFileBackedOutputStream() {
            return this.fileBackedOutputStream;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public String toString() {
            return new StringJoiner(", ", MultipartUploadHolder.class.getSimpleName() + "[", "]").add("filename='" + this.filename + "'").add("fileBackedOutputStream=" + this.fileBackedOutputStream).add("mediaType=" + this.mediaType).toString();
        }
    }
}

