/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl.util;

import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.exceptions.AbstractRestException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;

public interface DataAccessUtilMixin {
    default public <T> T tryAction(StorageSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (AbstractRestException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SystemErrorException(e);
        }
    }

    default public void tryAction(StorageCaller supplier) {
        try {
            supplier.call();
        }
        catch (AbstractRestException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SystemErrorException(e);
        }
    }

    @FunctionalInterface
    public static interface StorageCaller {
        public void call() throws StorageException, Exception;
    }

    @FunctionalInterface
    public static interface StorageSupplier<T> {
        public T get() throws StorageException, Exception;
    }
}

