/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications.producers;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.events.ContractCreatedEvent;
import io.apiman.manager.api.beans.events.IVersionedApimanEvent;
import io.apiman.manager.api.beans.notifications.NotificationCategory;
import io.apiman.manager.api.beans.notifications.dto.CreateNotificationDto;
import io.apiman.manager.api.beans.notifications.dto.RecipientDto;
import io.apiman.manager.api.beans.notifications.dto.RecipientType;
import io.apiman.manager.api.notifications.INotificationProducer;
import io.apiman.manager.api.service.NotificationService;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;

@ApplicationScoped
public class ContractRequestUserNotificationProducer
implements INotificationProducer {
    public static final String APIMAN_CLIENT_CONTRACT_REQUEST_REASON = "apiman.client.contract.request.user";
    private final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(ContractRequestUserNotificationProducer.class);
    private final NotificationService notificationService;

    @Inject
    public ContractRequestUserNotificationProducer(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void processEvent(@Observes ContractCreatedEvent signupEvent) {
        this.LOGGER.debug("Processing signup event {0}", new Object[]{signupEvent});
        if (signupEvent.isApprovalRequired()) {
            CreateNotificationDto newNotification = new CreateNotificationDto();
            String orgId = signupEvent.getApiOrgId();
            RecipientDto requester = new RecipientDto().setRecipient(signupEvent.getUser().getUsername()).setOrgId(orgId).setRecipientType(RecipientType.INDIVIDUAL);
            newNotification.setRecipient(List.of(requester)).setReason(APIMAN_CLIENT_CONTRACT_REQUEST_REASON).setReasonMessage("Signup for API").setCategory(NotificationCategory.API_LIFECYCLE).setSource("/apiman/notifications/contracts/approvals").setPayload((IVersionedApimanEvent)signupEvent);
            this.LOGGER.debug("Sending notification for user requested contract {0} from client {1} version {2}", new Object[]{signupEvent.getContractId(), signupEvent.getClientId(), signupEvent.getClientVersion()});
            this.notificationService.sendNotification(newNotification);
        }
    }
}

