/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications.email.handlers;

import io.apiman.manager.api.beans.events.ContractCreatedEvent;
import io.apiman.manager.api.beans.events.IVersionedApimanEvent;
import io.apiman.manager.api.beans.idm.UserDto;
import io.apiman.manager.api.beans.notifications.EmailNotificationTemplate;
import io.apiman.manager.api.beans.notifications.dto.NotificationDto;
import io.apiman.manager.api.notifications.email.SimpleEmail;
import io.apiman.manager.api.notifications.email.SimpleMailNotificationService;
import io.apiman.manager.api.notifications.email.handlers.INotificationHandler;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.inject.Inject;

@ApplicationScoped
public class ContractRequestUserEmailNotification
implements INotificationHandler<ContractCreatedEvent> {
    private final SimpleMailNotificationService mailNotificationService;

    @Inject
    public ContractRequestUserEmailNotification(SimpleMailNotificationService mailNotificationService) {
        this.mailNotificationService = mailNotificationService;
    }

    public void init(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
    }

    @Override
    public void handle(NotificationDto<ContractCreatedEvent> notification, Map<String, Object> defaultTemplateMap) {
        ContractCreatedEvent event = (ContractCreatedEvent)notification.getPayload();
        if (event.isApprovalRequired()) {
            UserDto recipient = notification.getRecipient();
            this.mailNotificationService.findTemplateFor(notification.getReason(), recipient.getLocale()).ifPresentOrElse(template -> this.send(recipient, (EmailNotificationTemplate)template, defaultTemplateMap), () -> this.warnOnce(recipient, (NotificationDto<IVersionedApimanEvent>)notification));
        }
    }

    private void send(UserDto recipient, EmailNotificationTemplate template, Map<String, Object> defaultTemplateMap) {
        SimpleEmail mail = SimpleEmail.builder().setRecipient(recipient).setTemplate(template).setTemplateVariables(defaultTemplateMap).build();
        this.mailNotificationService.send(mail);
    }

    @Override
    public boolean wants(NotificationDto<? extends IVersionedApimanEvent> notification) {
        return notification.getReason().equals("apiman.client.contract.request.user");
    }
}

