/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications.email.handlers;

import io.apiman.manager.api.beans.events.AccountSignupEvent;
import io.apiman.manager.api.beans.events.IVersionedApimanEvent;
import io.apiman.manager.api.beans.idm.UserDto;
import io.apiman.manager.api.beans.notifications.EmailNotificationTemplate;
import io.apiman.manager.api.beans.notifications.dto.NotificationDto;
import io.apiman.manager.api.notifications.email.SimpleEmail;
import io.apiman.manager.api.notifications.email.SimpleMailNotificationService;
import io.apiman.manager.api.notifications.email.handlers.INotificationHandler;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class AccountSignupApprovalEmailNotification
implements INotificationHandler<AccountSignupEvent> {
    private final SimpleMailNotificationService mailNotificationService;

    @Inject
    public AccountSignupApprovalEmailNotification(SimpleMailNotificationService mailNotificationService) {
        this.mailNotificationService = mailNotificationService;
    }

    @Override
    public void handle(NotificationDto<AccountSignupEvent> signupNotification, Map<String, Object> defaultTemplateMap) {
        UserDto recipient = signupNotification.getRecipient();
        this.mailNotificationService.findTemplateFor(signupNotification.getReason(), recipient.getLocale()).ifPresentOrElse(template -> this.send(recipient, (EmailNotificationTemplate)template, defaultTemplateMap), () -> this.warnOnce(recipient, (NotificationDto<IVersionedApimanEvent>)signupNotification));
    }

    private void send(UserDto recipient, EmailNotificationTemplate template, Map<String, Object> defaultTemplateMap) {
        SimpleEmail mail = SimpleEmail.builder().setRecipient(recipient).setTemplate(template).setTemplateVariables(defaultTemplateMap).build();
        this.mailNotificationService.send(mail);
    }

    @Override
    public boolean wants(NotificationDto<? extends IVersionedApimanEvent> notification) {
        return notification.getReason().equals("apiman.account.approval.request");
    }
}

