/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications.email;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.quarkus.qute.Engine;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.ValueResolver;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.NotNull;

@ApplicationScoped
public class QuteTemplateEngine {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(QuteTemplateEngine.class);
    private final Engine engine = Engine.builder().addDefaults().addValueResolver((ValueResolver)new ReflectionValueResolver()).build();

    @Inject
    public QuteTemplateEngine(ApiManagerConfig apimanConfig) {
        Path includesDir = apimanConfig.getConfigDirectory().resolve("notifications/email/tpl/includes");
        try (Stream<Path> files = Files.walk(includesDir, 10, new FileVisitOption[0]);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::notHiddenFile).forEach(f -> {
                String relativeToBaseDir = includesDir.relativize((Path)f).toString();
                Template parsedTpl = this.engine.parse(this.readTemplate((Path)f));
                LOGGER.debug("Adding include template: {0}", new Object[]{relativeToBaseDir});
                this.engine.putTemplate(relativeToBaseDir, parsedTpl);
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public String applyTemplate(@NotNull String rawTemplate, @NotNull Map<String, Object> values) {
        if (Strings.isBlank((String)rawTemplate)) {
            return "";
        }
        LOGGER.trace("Applying template {0} with values {1}", new Object[]{rawTemplate, values});
        String result = this.doApplyTemplate(rawTemplate, values);
        LOGGER.trace("Rendered result: {0}", new Object[]{result});
        return result;
    }

    private String doApplyTemplate(String rawTemplate, Map<String, Object> values) {
        Template parsedTpl = this.engine.parse(rawTemplate);
        TemplateInstance tplInstance = parsedTpl.instance();
        values.forEach((arg_0, arg_1) -> ((TemplateInstance)tplInstance).data(arg_0, arg_1));
        return tplInstance.render();
    }

    private boolean notHiddenFile(Path p) {
        try {
            return !Files.isHidden(p);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String readTemplate(Path p) {
        try {
            return Files.readString(p);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

