/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications.email;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.events.IVersionedApimanEvent;
import io.apiman.manager.api.beans.notifications.NotificationType;
import io.apiman.manager.api.beans.notifications.dto.NotificationDto;
import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.apiman.manager.api.notifications.email.handlers.INotificationHandler;
import io.apiman.manager.api.service.NotificationService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
public class EmailNotificationDispatcher {
    private final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(EmailNotificationDispatcher.class);
    private final List<INotificationHandler<?>> handlers;
    private final NotificationService notificationService;
    private final ApiManagerConfig config;

    @Inject
    public EmailNotificationDispatcher(@Any Instance<INotificationHandler<?>> handlers, NotificationService notificationService, ApiManagerConfig config) {
        this.handlers = handlers.stream().collect(Collectors.toList());
        this.notificationService = notificationService;
        this.config = config;
    }

    public void processNotification(@ObservesAsync NotificationDto<?> notification) {
        boolean wantsNotification = this.notificationService.userWantsNotification(notification.getRecipient().getUsername(), NotificationType.EMAIL, notification);
        if (wantsNotification) {
            this.dispatch(notification);
        } else {
            this.LOGGER.trace("Notification recipient did not want an email for {0}", new Object[]{notification});
        }
    }

    private void dispatch(NotificationDto<?> notification) {
        this.LOGGER.trace("Notification is a candidate for processing: {0}", new Object[]{notification});
        Map<String, Object> defaultTemplateMap = EmailNotificationDispatcher.createDefaultTemplateMap(notification, this.config);
        this.handlers.stream().filter(handler -> handler.wants((NotificationDto<IVersionedApimanEvent>)notification)).forEach(handler -> handler.handle(notification, defaultTemplateMap));
    }

    public static Map<String, Object> createDefaultTemplateMap(NotificationDto<?> notification, ApiManagerConfig config) {
        return Map.of("notification", notification, "event", notification.getPayload(), "apiman-manager-ui-endpoint", StringUtils.removeEnd((String)config.getApimanManagerUiEndpoint(), (String)"/"));
    }
}

