/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.apiman.manager.api.beans.notifications.NotificationFilterEntity;
import io.apiman.manager.api.beans.notifications.NotificationPreferenceEntity;
import io.apiman.manager.api.beans.notifications.NotificationType;
import io.apiman.manager.api.beans.notifications.dto.NotificationDto;
import io.apiman.manager.api.core.INotificationRepository;
import io.apiman.manager.api.notifications.rules.SimpleSpELRule;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jeasy.rules.api.Fact;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.support.composite.ActivationRuleGroup;

public class NotificationRulesService {
    private final INotificationRepository notificationRepository;
    private final Cache<RuleKey, ActivationRuleGroup> notificationsRuleCache = Caffeine.newBuilder().maximumSize(5000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    @Inject
    public NotificationRulesService(INotificationRepository notificationRepository) {
        this.notificationRepository = notificationRepository;
    }

    public NotificationRulesService cache(NotificationPreferenceEntity npe) {
        RuleKey key = RuleKey.of(npe.getUser().getUsername(), npe.getType());
        this.notificationRepository.getNotificationPreferenceByUserIdAndType(key.userId, key.nType).map(entity -> this.buildRuleGroup((NotificationPreferenceEntity)entity, key));
        return this;
    }

    public NotificationRulesService cache(String userId, NotificationType notificationType) {
        RuleKey key = RuleKey.of(userId, notificationType);
        this.notificationRepository.getNotificationPreferenceByUserIdAndType(key.userId, key.nType).map(entity -> this.buildRuleGroup((NotificationPreferenceEntity)entity, key));
        return this;
    }

    public NotificationRulesService invalidate(String userId, NotificationType notificationType) {
        this.notificationsRuleCache.invalidate((Object)RuleKey.of(userId, notificationType));
        return this;
    }

    public NotificationRulesService invalidateAll() {
        this.notificationsRuleCache.invalidateAll();
        return this;
    }

    public boolean wantsNotification(String userId, NotificationType notificationType, NotificationDto<?> notification) {
        RuleKey key = RuleKey.of(userId, notificationType);
        ActivationRuleGroup ruleGroup = (ActivationRuleGroup)this.notificationsRuleCache.get((Object)key, k -> this.notificationRepository.getNotificationPreferenceByUserIdAndType(userId, notificationType).map(entity -> this.buildRuleGroup((NotificationPreferenceEntity)entity, key)).orElse(null));
        if (ruleGroup == null) {
            return true;
        }
        Facts facts = new Facts();
        facts.add(new Fact("notification", notification));
        return !ruleGroup.evaluate(facts);
    }

    private ActivationRuleGroup buildRuleGroup(NotificationPreferenceEntity npe, RuleKey key) {
        ActivationRuleGroup ruleGroup = new ActivationRuleGroup();
        for (NotificationFilterEntity nfe : npe.getRules()) {
            SimpleSpELRule rule = new SimpleSpELRule().name(nfe.getSource()).when(nfe.getExpression());
            ruleGroup.addRule((Object)rule);
        }
        this.notificationsRuleCache.put((Object)key, (Object)ruleGroup);
        return ruleGroup;
    }

    private static final class RuleKey {
        final String userId;
        final NotificationType nType;

        RuleKey(String userId, NotificationType nType) {
            this.userId = userId;
            this.nType = nType;
        }

        public static RuleKey of(String userId, NotificationType nType) {
            return new RuleKey(userId, nType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleKey ruleKey = (RuleKey)o;
            return Objects.equals(this.userId, ruleKey.userId) && this.nType == ruleKey.nType;
        }

        public int hashCode() {
            return Objects.hash(this.userId, this.nType);
        }

        public String toString() {
            return new StringJoiner(", ", RuleKey.class.getSimpleName() + "[", "]").add("userId='" + this.userId + "'").add("nType=" + this.nType).toString();
        }
    }
}

