/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.node10.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.NodeOSException;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.kernel.Charsets;
import io.apigee.trireme.kernel.http.HTTPParsingMachine;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPParser
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(HTTPParser.class);

    public String getModuleName() {
        return "http_parser";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Scriptable exports = cx.newObject(scope);
        exports.setParentScope(null);
        exports.setPrototype(scope);
        ScriptableObject.defineClass((Scriptable)exports, ParserImpl.class);
        FunctionObject fn = new FunctionObject("HTTPParser", (Member)Utils.findMethod(ParserImpl.class, (String)"newParser"), exports);
        fn.put("REQUEST", (Scriptable)fn, (Object)1);
        fn.put("RESPONSE", (Scriptable)fn, (Object)2);
        exports.put("HTTPParser", exports, (Object)fn);
        return exports;
    }

    public static class ParserImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_httpParserClass";
        private static final ByteBuffer EMPTY_BUF = ByteBuffer.allocate(0);
        public static final int REQUEST = 1;
        public static final int RESPONSE = 2;
        private HTTPParsingMachine parser;
        private boolean sentPartialHeaders;
        private boolean sentCompleteHeaders;
        private Function onHeaders;
        private Function onHeadersComplete;
        private Function onBody;
        private Function onMessageComplete;

        public String getClassName() {
            return CLASS_NAME;
        }

        private void init(int type) {
            this.parser = new HTTPParsingMachine(type == 1 ? HTTPParsingMachine.ParsingMode.REQUEST : HTTPParsingMachine.ParsingMode.RESPONSE);
            this.sentPartialHeaders = false;
            this.sentCompleteHeaders = false;
        }

        public static Object newParser(Context cx, Scriptable thisObj, Object[] args, Function fn) {
            int typeArg = ArgUtils.intArg((Object[])args, (int)0);
            ParserImpl parser = (ParserImpl)cx.newObject(thisObj, CLASS_NAME);
            parser.init(typeArg);
            return parser;
        }

        @JSGetter(value="onHeaders")
        public Function getOnHeaders() {
            return this.onHeaders;
        }

        @JSSetter(value="onHeaders")
        public void setOnHeaders(Function onHeaders) {
            this.onHeaders = onHeaders;
        }

        @JSGetter(value="onHeadersComplete")
        public Function getOnHeadersComplete() {
            return this.onHeadersComplete;
        }

        @JSSetter(value="onHeadersComplete")
        public void setOnHeadersComplete(Function onHeadersComplete) {
            this.onHeadersComplete = onHeadersComplete;
        }

        @JSGetter(value="onBody")
        public Function getOnBody() {
            return this.onBody;
        }

        @JSSetter(value="onBody")
        public void setOnBody(Function onBody) {
            this.onBody = onBody;
        }

        @JSGetter(value="onMessageComplete")
        public Function getOnMessageComplete() {
            return this.onMessageComplete;
        }

        @JSSetter(value="onMessageComplete")
        public void setOnMessageComplete(Function onMessageComplete) {
            this.onMessageComplete = onMessageComplete;
        }

        @JSFunction
        public void reinitialize(int type) {
            log.debug("HTTP parser: init");
            this.init(type);
        }

        @JSFunction
        public void pause() {
        }

        @JSFunction
        public void resume() {
        }

        @JSFunction
        public static void finish(Context cx, Scriptable thisObj, Object[] args, Function ctorObj) {
            log.debug("HTTP parser finished with input");
            ((ParserImpl)thisObj).finish(cx);
        }

        private Object finish(Context cx) {
            try {
                this.execute(cx, EMPTY_BUF);
                return Context.getUndefinedValue();
            }
            catch (NodeOSException ne) {
                return Utils.makeErrorObject((Context)cx, (Scriptable)this, (String)"Parse Error", (String)ne.getCode());
            }
        }

        @JSFunction
        public static Object execute(Context cx, Scriptable thisObj, Object[] args, Function ctorObj) {
            Buffer.BufferImpl bufObj = (Buffer.BufferImpl)ArgUtils.objArg((Object[])args, (int)0, Buffer.BufferImpl.class, (boolean)true);
            int offset = ArgUtils.intArg((Object[])args, (int)1);
            int length = ArgUtils.intArg((Object[])args, (int)2);
            ParserImpl p = (ParserImpl)thisObj;
            ByteBuffer bBuf = bufObj.getBuffer();
            bBuf.position(bBuf.position() + offset);
            bBuf.limit(bBuf.position() + length);
            try {
                return p.execute(cx, bBuf);
            }
            catch (NodeOSException noe) {
                return Utils.makeErrorObject((Context)cx, (Scriptable)thisObj, (String)"Parse Error", (String)noe.getCode());
            }
        }

        private int execute(Context cx, ByteBuffer bBuf) {
            HTTPParsingMachine.Result result;
            boolean hadSomething;
            int startPos = bBuf.position();
            do {
                if (log.isDebugEnabled()) {
                    log.debug("Parser.execute: buf = {}", (Object)bBuf);
                    if (log.isTraceEnabled()) {
                        log.trace("buffer: " + Utils.bufferToString((ByteBuffer)bBuf, (Charset)Charsets.DEFAULT));
                    }
                }
                hadSomething = false;
                boolean wasComplete = false;
                result = this.parser.parse(bBuf);
                if (result.isError()) {
                    if (log.isDebugEnabled()) {
                        log.debug("HTTP parser error");
                    }
                    throw new NodeOSException("HPE_INVALID_CONSTANT");
                }
                if (!this.sentCompleteHeaders) {
                    if (result.isHeadersComplete() || result.isComplete()) {
                        this.sentCompleteHeaders = true;
                        hadSomething = true;
                        log.debug("Sending complete HTTP headers");
                        if (result.hasHeaders() && this.sentPartialHeaders) {
                            this.callOnHeaders(cx, result);
                        }
                        if (this.callOnHeadersComplete(cx, result)) {
                            this.parser.setIgnoreBody(true);
                        }
                    } else if (result.hasHeaders()) {
                        hadSomething = true;
                        log.debug("Sending partial HTTP headers");
                        this.sentPartialHeaders = true;
                        this.callOnHeaders(cx, result);
                    }
                }
                if (result.hasTrailers()) {
                    hadSomething = true;
                    if (log.isDebugEnabled()) {
                        log.debug("Sending HTTP trailers");
                    }
                    this.callOnTrailers(cx, result);
                }
                if (result.hasBody()) {
                    hadSomething = true;
                    if (log.isDebugEnabled()) {
                        log.debug("Sending HTTP body {}", (Object)result.getBody());
                    }
                    this.callOnBody(cx, result);
                }
                if (result.isComplete()) {
                    log.debug("Sending HTTP request complete");
                    hadSomething = true;
                    wasComplete = true;
                    this.callOnComplete(cx);
                    this.sentPartialHeaders = false;
                    this.sentCompleteHeaders = false;
                    this.parser.reset();
                }
                log.debug("hadSomething = {} result.isComplete = {} remaining = {} ret = {}", new Object[]{hadSomething, wasComplete, bBuf.remaining(), bBuf.position() - startPos});
            } while (hadSomething && bBuf.hasRemaining() && !result.isConnectRequest());
            return bBuf.position() - startPos;
        }

        private boolean callOnHeadersComplete(Context cx, HTTPParsingMachine.Result result) {
            if (this.onHeadersComplete == null) {
                return false;
            }
            Scriptable info = cx.newObject((Scriptable)this);
            if (!this.sentPartialHeaders) {
                Scriptable headers = this.buildHeaders(cx, result);
                info.put("headers", info, (Object)headers);
            }
            info.put("url", info, (Object)result.getUri());
            info.put("versionMajor", info, (Object)result.getMajor());
            info.put("versionMinor", info, (Object)result.getMinor());
            info.put("method", info, (Object)result.getMethod());
            info.put("statusCode", info, (Object)result.getStatusCode());
            info.put("upgrade", info, (Object)(result.isUpgradeRequested() || "connect".equalsIgnoreCase(result.getMethod()) ? 1 : 0));
            info.put("shouldKeepAlive", info, (Object)result.shouldKeepAlive());
            Object ret = this.onHeadersComplete.call(cx, (Scriptable)this.onHeadersComplete, (Scriptable)this, new Object[]{info});
            if (ret == null || !(ret instanceof Boolean)) {
                return false;
            }
            return (Boolean)ret;
        }

        private void callOnHeaders(Context cx, HTTPParsingMachine.Result result) {
            if (this.onHeaders == null) {
                return;
            }
            Scriptable headers = this.buildHeaders(cx, result);
            this.onHeaders.call(cx, (Scriptable)this.onHeaders, (Scriptable)this, new Object[]{headers, result.getUri()});
        }

        private void callOnTrailers(Context cx, HTTPParsingMachine.Result result) {
            if (this.onHeaders == null) {
                return;
            }
            Scriptable trailers = this.buildTrailers(cx, result);
            this.onHeaders.call(cx, (Scriptable)this.onHeaders, (Scriptable)this, new Object[]{trailers, result.getUri()});
        }

        private void callOnBody(Context cx, HTTPParsingMachine.Result result) {
            if (this.onBody == null) {
                return;
            }
            Buffer.BufferImpl buf = Buffer.BufferImpl.newBuffer((Context)cx, (Scriptable)this, (ByteBuffer)result.getBody(), (boolean)false);
            this.onBody.call(cx, (Scriptable)this.onBody, (Scriptable)this, new Object[]{buf, 0, buf.getLength()});
        }

        private void callOnComplete(Context cx) {
            if (this.onMessageComplete == null) {
                return;
            }
            this.onMessageComplete.call(cx, (Scriptable)this.onMessageComplete, (Scriptable)this, ScriptRuntime.emptyArgs);
        }

        private Scriptable buildHeaders(Context cx, HTTPParsingMachine.Result result) {
            return this.buildMap(cx, result.getHeaders());
        }

        private Scriptable buildTrailers(Context cx, HTTPParsingMachine.Result result) {
            return this.buildMap(cx, result.getTrailers());
        }

        private Scriptable buildMap(Context cx, List<Map.Entry<String, String>> l) {
            if (l == null) {
                return cx.newArray((Scriptable)this, 0);
            }
            Object[] headers = new Object[l.size() * 2];
            int i = 0;
            for (Map.Entry<String, String> hdr : l) {
                headers[i++] = hdr.getKey();
                headers[i++] = hdr.getValue();
            }
            return cx.newArray((Scriptable)this, headers);
        }
    }
}

