/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.node10.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.Referenceable;
import io.apigee.trireme.kernel.ErrorCodes;
import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.Handle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.handles.NIOSocketHandle;
import io.apigee.trireme.kernel.handles.SocketHandle;
import io.apigee.trireme.net.NetUtils;
import io.apigee.trireme.node10.modules.JavaStreamWrap;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPWrap
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(TCPWrap.class);

    public String getModuleName() {
        return "tcp_wrap";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject exports = (ScriptableObject)cx.newObject(scope);
        exports.setPrototype(scope);
        exports.setParentScope(null);
        ScriptableObject.defineClass((Scriptable)exports, Referenceable.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)exports, JavaStreamWrap.StreamWrapImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)exports, TCPImpl.class, (boolean)false, (boolean)true);
        return exports;
    }

    public static class TCPImpl
    extends JavaStreamWrap.StreamWrapImpl {
        public static final String CLASS_NAME = "TCP";
        private Function onConnection;
        private SocketHandle sockHandle;

        public TCPImpl() {
        }

        protected TCPImpl(SocketHandle handle, ScriptRunner runtime) {
            super((Handle)handle, runtime);
            this.sockHandle = handle;
        }

        @JSConstructor
        public static Object newTCPImpl(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
            if (!inNewExpr) {
                return cx.newObject((Scriptable)ctorObj, CLASS_NAME, args);
            }
            ScriptRunner runner = TCPImpl.getRunner((Context)cx);
            SocketHandle handle = (SocketHandle)ArgUtils.objArg((Object[])args, (int)0, SocketHandle.class, (boolean)false);
            if (handle == null) {
                handle = new NIOSocketHandle((GenericNodeRuntime)runner);
            }
            TCPImpl tcp = new TCPImpl(handle, runner);
            tcp.requestPin();
            return tcp;
        }

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSSetter(value="onconnection")
        public void setOnConnection(Function oc) {
            this.onConnection = oc;
        }

        @JSGetter(value="onconnection")
        public Function getOnConnection() {
            return this.onConnection;
        }

        @JSFunction
        public String bind(String address, int port) {
            try {
                this.sockHandle.bind(address, port);
                TCPImpl.clearErrno();
            }
            catch (OSException ose) {
                TCPImpl.setErrno((int)ose.getCode());
                return ose.getStringCode();
            }
            return null;
        }

        @JSFunction
        public String bind6(String address, int port) {
            return this.bind(address, port);
        }

        @JSFunction
        public String listen(int backlog) {
            try {
                this.sockHandle.listen(backlog, (IOCompletionHandler)new IOCompletionHandler<AbstractHandle>(){

                    public void ioComplete(int errCode, AbstractHandle value) {
                        TCPImpl.this.onConnection(value);
                    }
                });
                TCPImpl.clearErrno();
                return null;
            }
            catch (OSException ose) {
                TCPImpl.setErrno((int)ose.getCode());
                return ose.getStringCode();
            }
        }

        protected void onConnection(AbstractHandle handle) {
            Context cx = Context.getCurrentContext();
            if (this.onConnection != null) {
                TCPImpl sock = (TCPImpl)cx.newObject((Scriptable)this, CLASS_NAME, new Object[]{handle});
                this.onConnection.call(cx, (Scriptable)this.onConnection, (Scriptable)this, new Object[]{sock});
            }
        }

        @JSFunction
        public static Object connect(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final TCPImpl tcp = (TCPImpl)thisObj;
            String host = ArgUtils.stringArg((Object[])args, (int)0);
            int port = ArgUtils.intArg((Object[])args, (int)1);
            final Scriptable pending = cx.newObject(thisObj);
            try {
                tcp.sockHandle.connect(host, port, (IOCompletionHandler)new IOCompletionHandler<Integer>(){

                    public void ioComplete(int errCode, Integer value) {
                        tcp.connectComplete(errCode, pending);
                    }
                });
            }
            catch (OSException ose) {
                TCPImpl.setErrno((int)ose.getCode());
                return null;
            }
            return pending;
        }

        @JSFunction
        public static Object connect6(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return TCPImpl.connect(cx, thisObj, args, func);
        }

        protected void connectComplete(int err, Scriptable s) {
            Object onComplete = ScriptableObject.getProperty((Scriptable)s, (String)"oncomplete");
            if (onComplete != null) {
                boolean readable;
                boolean writable;
                Object errStr;
                Context cx = Context.getCurrentContext();
                Function ocf = (Function)onComplete;
                if (err == 0) {
                    TCPImpl.clearErrno();
                    errStr = 0;
                    writable = true;
                    readable = true;
                } else {
                    TCPImpl.setErrno((int)err);
                    errStr = ErrorCodes.get().toString(err);
                    writable = false;
                    readable = false;
                }
                ocf.call(cx, (Scriptable)ocf, (Scriptable)this, new Object[]{errStr, this, s, readable, writable});
            }
        }

        @JSFunction
        public static Object shutdown(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final TCPImpl tcp = (TCPImpl)thisObj;
            final Scriptable req = cx.newObject((Scriptable)tcp);
            TCPImpl.clearErrno();
            tcp.sockHandle.shutdown((IOCompletionHandler)new IOCompletionHandler<Integer>(){

                public void ioComplete(int errCode, Integer value) {
                    tcp.writeComplete(errCode, 0, req);
                }
            });
            return req;
        }

        @JSFunction
        public static Object getsockname(Context cx, Scriptable thisObj, Object[] args, Function func) {
            TCPImpl tcp = (TCPImpl)thisObj;
            TCPImpl.clearErrno();
            InetSocketAddress addr = tcp.sockHandle.getSockName();
            if (addr == null) {
                return null;
            }
            return NetUtils.formatAddress((InetAddress)addr.getAddress(), (int)addr.getPort(), (Context)cx, (Scriptable)thisObj);
        }

        @JSFunction
        public static Object getpeername(Context cx, Scriptable thisObj, Object[] args, Function func) {
            TCPImpl tcp = (TCPImpl)thisObj;
            TCPImpl.clearErrno();
            InetSocketAddress addr = tcp.sockHandle.getPeerName();
            if (addr == null) {
                return null;
            }
            return NetUtils.formatAddress((InetAddress)addr.getAddress(), (int)addr.getPort(), (Context)cx, (Scriptable)thisObj);
        }

        @JSFunction
        public void setNoDelay(boolean nd) {
            try {
                this.sockHandle.setNoDelay(nd);
                TCPImpl.clearErrno();
            }
            catch (OSException ose) {
                TCPImpl.setErrno((int)ose.getCode());
            }
        }

        @JSFunction
        public void setKeepAlive(boolean nd) {
            try {
                this.sockHandle.setKeepAlive(nd);
                TCPImpl.clearErrno();
            }
            catch (OSException ose) {
                TCPImpl.setErrno((int)ose.getCode());
            }
        }
    }
}

