/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.util;

import io.apigee.trireme.kernel.GenericNodeRuntime;

public class PinState {
    public static final int PIN_REQUESTED = 1;
    public static final int PIN_ALLOWED = 2;
    private static final int PINNABLE = 3;
    private int pinState = 2;
    private int requestCount;

    private void updatePinState(int newState, GenericNodeRuntime runtime) {
        if (this.pinState != 3 && newState == 3) {
            runtime.pin();
        } else if (this.pinState == 3 && newState != 3) {
            runtime.unPin();
        }
        this.pinState = newState;
    }

    public void ref(GenericNodeRuntime runtime) {
        this.updatePinState(this.pinState | 2, runtime);
    }

    public void unref(GenericNodeRuntime runtime) {
        this.updatePinState(this.pinState & 0xFFFFFFFD, runtime);
    }

    public void requestPin(GenericNodeRuntime runtime) {
        this.updatePinState(this.pinState | 1, runtime);
    }

    public void clearPin(GenericNodeRuntime runtime) {
        this.updatePinState(this.pinState & 0xFFFFFFFE, runtime);
    }

    public void incrementPinRequest(GenericNodeRuntime runtime) {
        if (this.requestCount == 0) {
            this.requestPin(runtime);
        }
        ++this.requestCount;
    }

    public void decrementPinRequest(GenericNodeRuntime runtime) {
        --this.requestCount;
        if (this.requestCount == 0) {
            this.clearPin(runtime);
        }
    }
}

