/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class BufferUtils {
    public static ByteBuffer catBuffers(ByteBuffer b1, ByteBuffer b2) {
        if (b1 != null && b2 == null) {
            return b1;
        }
        if (b1 == null && b2 != null) {
            return b2;
        }
        int len = (b1 == null ? 0 : b1.remaining()) + (b2 == null ? 0 : b2.remaining());
        if (len == 0) {
            return null;
        }
        ByteBuffer r = ByteBuffer.allocate(len);
        if (b1 != null) {
            r.put(b1);
        }
        if (b2 != null) {
            r.put(b2);
        }
        r.flip();
        return r;
    }

    public static CharBuffer doubleBuffer(CharBuffer b) {
        int newCap = Math.max(b.capacity() * 2, 1);
        CharBuffer d = CharBuffer.allocate(newCap);
        b.flip();
        d.put(b);
        return d;
    }

    public static ByteBuffer doubleBuffer(ByteBuffer b) {
        int newCap = Math.max(b.capacity() * 2, 1);
        ByteBuffer d = ByteBuffer.allocate(newCap);
        b.flip();
        d.put(b);
        return d;
    }

    public static void zeroBuffer(ByteBuffer b) {
        b.clear();
        while (b.hasRemaining()) {
            b.put((byte)0);
        }
        b.clear();
    }

    public static ByteBuffer duplicateBuffer(ByteBuffer b) {
        ByteBuffer ret = ByteBuffer.allocate(b.remaining());
        ByteBuffer tmp = b.duplicate();
        ret.put(tmp);
        ret.flip();
        return ret;
    }
}

