/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamPiper
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(StreamPiper.class);
    public static final int BUFFER_SIZE = 8192;
    private final InputStream in;
    private final OutputStream out;
    private final boolean closeEm;

    public StreamPiper(InputStream in, OutputStream out, boolean closeEm) {
        this.in = in;
        this.out = out;
        this.closeEm = closeEm;
    }

    public void start(ExecutorService exec) {
        exec.execute(this);
    }

    @Override
    public void run() {
        try {
            try {
                int readLen;
                byte[] buf = new byte[8192];
                do {
                    if ((readLen = this.in.read(buf)) <= 0) continue;
                    this.out.write(buf, 0, readLen);
                } while (readLen >= 0);
            }
            finally {
                if (this.closeEm) {
                    this.in.close();
                    this.out.close();
                }
            }
        }
        catch (IOException ioe) {
            log.debug("Error in OutputStream -> InputStream pipe: {}", (Throwable)ioe);
        }
    }
}

