/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.streams;

import java.io.OutputStream;

public class CircularOutputStream
extends OutputStream {
    public static final int DEFAULT_INITIAL_SIZE = 1024;
    private final int maxSize;
    private byte[] buf;
    private boolean full;
    private int position;

    public CircularOutputStream(int maxSize, int initialSize) {
        this.maxSize = maxSize;
        this.buf = new byte[initialSize];
    }

    public CircularOutputStream(int maxSize) {
        this(maxSize, Math.min(maxSize, 1024));
    }

    private void expand() {
        assert (this.buf.length < this.maxSize);
        int newLen = Math.min(this.buf.length * 2, this.maxSize);
        byte[] newBuf = new byte[newLen];
        System.arraycopy(this.buf, 0, newBuf, 0, this.position + 1);
        this.buf = newBuf;
    }

    @Override
    public void write(int i) {
        if (!this.full && this.buf.length < this.maxSize && this.position == this.buf.length - 1) {
            this.expand();
        }
        this.buf[this.position] = (byte)(i & 0xFF);
        ++this.position;
        if (this.position == this.buf.length) {
            this.position = 0;
            this.full = true;
        }
    }

    @Override
    public void write(byte[] in, int offset, int length) {
        while (!this.full && this.buf.length < this.maxSize && this.buf.length - this.position < length) {
            this.expand();
        }
        for (int p = 0; p < length; ++p) {
            this.write(in[p + offset]);
        }
    }

    public byte[] toByteArray() {
        byte[] ret;
        if (this.full) {
            ret = new byte[this.buf.length];
            System.arraycopy(this.buf, this.position, ret, 0, this.buf.length - this.position);
            System.arraycopy(this.buf, 0, ret, this.buf.length - this.position, this.position);
        } else {
            ret = new byte[this.position];
            System.arraycopy(this.buf, 0, ret, 0, this.position);
        }
        return ret;
    }
}

