/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.handles;

import io.apigee.trireme.kernel.BiCallback;
import io.apigee.trireme.kernel.Callback;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.TriCallback;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.handles.SocketHandle;
import io.apigee.trireme.kernel.tls.TLSConnection;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSHandle
extends AbstractHandle
implements SocketHandle {
    private static final Logger log = LoggerFactory.getLogger(TLSHandle.class);
    private final SocketHandle handle;
    private final TLSConnection tls;
    private IOCompletionHandler<ByteBuffer> readHandler;

    public TLSHandle(final SocketHandle handle, TLSConnection tls) {
        this.handle = handle;
        this.tls = tls;
        tls.setWriteCallback(new TriCallback<ByteBuffer, Boolean, Object>(){

            @Override
            public void call(ByteBuffer buf, final Boolean isShutdown, Object cb) {
                final Callback callback = (Callback)cb;
                if (buf != null && buf.hasRemaining()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Delivering {} bytes to the network. wasShutdown = {}", (Object)buf, (Object)isShutdown);
                    }
                    handle.write(buf, new IOCompletionHandler<Integer>(){

                        @Override
                        public void ioComplete(int errCode, Integer value) {
                            if (isShutdown.booleanValue()) {
                                handle.shutdown(new IOCompletionHandler<Integer>(){

                                    @Override
                                    public void ioComplete(int errCode, Integer value) {
                                        if (callback != null) {
                                            callback.call(value);
                                        }
                                    }
                                });
                            } else if (callback != null) {
                                callback.call(value);
                            }
                        }
                    });
                } else if (isShutdown.booleanValue()) {
                    handle.shutdown(new IOCompletionHandler<Integer>(){

                        @Override
                        public void ioComplete(int errCode, Integer value) {
                            if (callback != null) {
                                callback.call(value);
                            }
                        }
                    });
                }
            }
        });
        if (handle.getReadHandler() != null) {
            IOCompletionHandler<ByteBuffer> handler = handle.getReadHandler();
            this.setTlsReadCallback(handler);
            handle.setReadHandler(this.createReadCallback());
        }
    }

    @Override
    public int write(ByteBuffer buf, final IOCompletionHandler<Integer> handler) {
        if (log.isTraceEnabled()) {
            log.trace("Sending {} via TLS", (Object)buf);
        }
        this.tls.wrap(buf, new Callback<Object>(){

            @Override
            public void call(Object val) {
                if (log.isTraceEnabled()) {
                    log.trace("Got {} result from TLS write", val);
                }
                if (handler != null) {
                    handler.ioComplete(0, (Integer)val);
                }
            }
        });
        return this.tls.getWriteQueueLength();
    }

    private void setTlsReadCallback(final IOCompletionHandler<ByteBuffer> handler) {
        this.tls.setReadCallback(new BiCallback<ByteBuffer, Integer>(){

            @Override
            public void call(ByteBuffer buf, Integer err) {
                if (log.isTraceEnabled()) {
                    log.trace("Received {} back from TLS. err = {}", (Object)buf, (Object)err);
                }
                handler.ioComplete(err, buf);
            }
        });
    }

    private IOCompletionHandler<ByteBuffer> createReadCallback() {
        return new IOCompletionHandler<ByteBuffer>(){

            @Override
            public void ioComplete(int errCode, ByteBuffer buf) {
                if (log.isTraceEnabled()) {
                    log.trace("Received {} from the network for TLS. err = {}", (Object)buf, (Object)errCode);
                }
                if (buf != null && buf.hasRemaining()) {
                    TLSHandle.this.tls.unwrap(buf, null);
                }
                if (errCode != 0) {
                    TLSHandle.this.tls.inboundError(errCode);
                }
            }
        };
    }

    @Override
    public void startReading(IOCompletionHandler<ByteBuffer> handler) {
        this.setTlsReadCallback(handler);
        this.readHandler = handler;
        this.handle.startReading(this.createReadCallback());
    }

    @Override
    public void shutdown(final IOCompletionHandler<Integer> handler) {
        log.trace("Sending TLS shutdown");
        this.tls.shutdown(new Callback<Object>(){

            @Override
            public void call(Object val) {
                handler.ioComplete(0, 0);
            }
        });
    }

    @Override
    public void stopReading() {
        this.handle.stopReading();
        this.readHandler = null;
    }

    @Override
    public void close() {
        this.handle.close();
    }

    @Override
    public void bind(String address, int port) throws OSException {
        this.handle.bind(address, port);
    }

    @Override
    public void listen(int backlog, IOCompletionHandler<AbstractHandle> handler) throws OSException {
        this.handle.listen(backlog, handler);
    }

    @Override
    public void connect(String host, int port, IOCompletionHandler<Integer> handler) throws OSException {
        this.handle.connect(host, port, handler);
    }

    @Override
    public InetSocketAddress getSockName() {
        return this.handle.getSockName();
    }

    @Override
    public InetSocketAddress getPeerName() {
        return this.handle.getPeerName();
    }

    @Override
    public void setNoDelay(boolean nd) throws OSException {
        this.handle.setNoDelay(nd);
    }

    @Override
    public void setKeepAlive(boolean ka) throws OSException {
        this.handle.setKeepAlive(ka);
    }
}

