/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.handles;

import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.handles.SocketHandle;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class NetworkPeerPipe
extends AbstractHandle
implements SocketHandle {
    private final ConcurrentLinkedQueue<QueuedWrite> writeQueue = new ConcurrentLinkedQueue();
    private final GenericNodeRuntime runtime;
    private InetSocketAddress socketAddress;
    private InetSocketAddress peerAddress;
    private NetworkPeerPipe peer;
    private IOCompletionHandler<ByteBuffer> readHandler;
    private volatile boolean reading;

    public NetworkPeerPipe(GenericNodeRuntime runtime) {
        this.runtime = runtime;
    }

    public void setSocketAddress(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    public void setPeerAddress(InetSocketAddress peerAddress) {
        this.peerAddress = peerAddress;
    }

    public NetworkPeerPipe getPeer() {
        return this.peer;
    }

    public void setPeer(NetworkPeerPipe peer) {
        this.peer = peer;
    }

    @Override
    public int write(ByteBuffer buf, IOCompletionHandler<Integer> handler) {
        QueuedWrite qw = new QueuedWrite();
        qw.buf = buf;
        qw.writeHandler = handler;
        int len = buf.remaining();
        this.writeQueue.add(qw);
        if (this.peer != null && this.peer.reading) {
            this.peer.drainWriteQueue();
        }
        return len;
    }

    @Override
    public void shutdown(IOCompletionHandler<Integer> handler) {
        if (this.peer == null) {
            return;
        }
        QueuedWrite qw = new QueuedWrite();
        qw.eof = true;
        this.writeQueue.add(qw);
        if (this.peer != null && this.peer.reading) {
            this.peer.drainWriteQueue();
        }
        this.peer = null;
    }

    @Override
    public void close() {
        this.shutdown(null);
    }

    @Override
    public void startReading(IOCompletionHandler<ByteBuffer> handler) {
        if (!this.reading) {
            this.reading = true;
            this.drainWriteQueue();
        }
    }

    @Override
    public void stopReading() {
        this.reading = false;
    }

    @Override
    public int getWritesOutstanding() {
        int len = 0;
        for (QueuedWrite qw : this.writeQueue) {
            ByteBuffer buf = qw.buf;
            len += buf == null ? 0 : buf.remaining();
        }
        return len;
    }

    private void drainWriteQueue() {
        this.runtime.executeScriptTask(new Runnable(){

            @Override
            public void run() {
                NetworkPeerPipe.this.doDrain();
            }
        }, null);
    }

    protected void doDrain() {
        if (this.peer != null) {
            QueuedWrite qw;
            do {
                if ((qw = this.peer.writeQueue.poll()) == null) continue;
                this.deliverWrite(qw);
            } while (this.reading && qw != null);
        }
    }

    private void deliverWrite(final QueuedWrite qw) {
        if (this.readHandler != null) {
            final int len = qw.buf == null ? 0 : qw.buf.remaining();
            final int err = qw.eof ? -99 : 0;
            this.readHandler.ioComplete(err, qw.buf);
            if (qw.writeHandler != null) {
                this.runtime.executeScriptTask(new Runnable(){

                    @Override
                    public void run() {
                        qw.writeHandler.ioComplete(err, len);
                    }
                }, null);
            }
        }
    }

    @Override
    public InetSocketAddress getSockName() {
        return this.socketAddress;
    }

    @Override
    public InetSocketAddress getPeerName() {
        return this.peerAddress;
    }

    @Override
    public void bind(String address, int port) throws OSException {
        throw new OSException(-200);
    }

    @Override
    public void listen(int backlog, IOCompletionHandler<AbstractHandle> handler) throws OSException {
        throw new OSException(-200);
    }

    @Override
    public void connect(String host, int port, IOCompletionHandler<Integer> handler) throws OSException {
        throw new OSException(-200);
    }

    @Override
    public void setNoDelay(boolean nd) {
    }

    @Override
    public void setKeepAlive(boolean nd) {
    }

    private static final class QueuedWrite {
        ByteBuffer buf;
        boolean eof;
        IOCompletionHandler<Integer> writeHandler;

        private QueuedWrite() {
        }
    }
}

