/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.handles;

import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.AbstractNIOHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.handles.SocketHandle;
import io.apigee.trireme.kernel.net.NetworkPolicy;
import io.apigee.trireme.kernel.net.SelectorHandler;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOSocketHandle
extends AbstractNIOHandle
implements SocketHandle {
    private static final Logger log = LoggerFactory.getLogger(NIOSocketHandle.class);
    public static final int READ_BUFFER_SIZE = Short.MAX_VALUE;
    private InetSocketAddress boundAddress;
    private ServerSocketChannel svrChannel;
    private SocketChannel clientChannel;
    private boolean readStarted;
    private ByteBuffer readBuffer;
    private IOCompletionHandler<AbstractHandle> serverConnectionHandler;
    private IOCompletionHandler<Integer> clientConnectionHandler;
    private IOCompletionHandler<ByteBuffer> readHandler;

    public NIOSocketHandle(GenericNodeRuntime runtime) {
        super(runtime);
    }

    public NIOSocketHandle(GenericNodeRuntime runtime, SocketChannel clientChannel) throws IOException, OSException {
        super(runtime);
        this.clientChannel = clientChannel;
        this.clientInit();
        this.selKey = clientChannel.register(runtime.getSelector(), 4, new SelectorHandler(){

            @Override
            public void selected(SelectionKey key) {
                NIOSocketHandle.this.clientSelected(key);
            }
        });
    }

    public boolean isServerChannel() {
        return this.svrChannel != null;
    }

    private void clientInit() throws IOException, OSException {
        this.readBuffer = ByteBuffer.allocate(Short.MAX_VALUE);
        this.clientChannel.configureBlocking(false);
        this.setNoDelay(true);
    }

    @Override
    public void close() {
        try {
            if (this.clientChannel != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing client channel {}", (Object)this.clientChannel);
                }
                this.clientChannel.close();
                this.runtime.unregisterCloseable(this.clientChannel);
            }
            if (this.svrChannel != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing server channel {}", (Object)this.svrChannel);
                }
                this.svrChannel.close();
                this.runtime.unregisterCloseable(this.svrChannel);
            }
        }
        catch (IOException ioe) {
            log.debug("Uncaught exception in channel close: {}", (Throwable)ioe);
        }
    }

    @Override
    public IOCompletionHandler<ByteBuffer> getReadHandler() {
        return this.readHandler;
    }

    @Override
    public void setReadHandler(IOCompletionHandler<ByteBuffer> h) {
        this.readHandler = h;
    }

    @Override
    public void bind(String address, int port) throws OSException {
        if (log.isDebugEnabled()) {
            log.debug("Client binding to {}:{}", (Object)address, (Object)port);
        }
        this.boundAddress = new InetSocketAddress(address, port);
        if (this.boundAddress.isUnresolved()) {
            throw new OSException(-2);
        }
    }

    @Override
    public void listen(int backlog, IOCompletionHandler<AbstractHandle> handler) throws OSException {
        if (this.boundAddress == null) {
            throw new OSException(-22);
        }
        NetworkPolicy netPolicy = this.getNetworkPolicy();
        if (netPolicy != null && !netPolicy.allowListening(this.boundAddress)) {
            log.debug("Address {} not allowed by network policy", (Object)this.boundAddress);
            throw new OSException(-22);
        }
        this.serverConnectionHandler = handler;
        if (log.isDebugEnabled()) {
            log.debug("Server listening on {} with backlog {}", (Object)this.boundAddress, (Object)backlog);
        }
        boolean success = false;
        try {
            this.svrChannel = ServerSocketChannel.open();
            this.runtime.registerCloseable(this.svrChannel);
            this.svrChannel.configureBlocking(false);
            this.svrChannel.socket().setReuseAddress(true);
            this.svrChannel.socket().bind(this.boundAddress, backlog);
            this.svrChannel.register(this.runtime.getSelector(), 16, new SelectorHandler(){

                @Override
                public void selected(SelectionKey key) {
                    NIOSocketHandle.this.serverSelected(key);
                }
            });
            success = true;
        }
        catch (BindException be) {
            log.debug("Error listening: {}", (Throwable)be);
            throw new OSException(-48);
        }
        catch (IOException ioe) {
            log.debug("Error listening: {}", (Throwable)ioe);
            throw new OSException(-5);
        }
        finally {
            if (!success && this.svrChannel != null) {
                this.runtime.unregisterCloseable(this.svrChannel);
                try {
                    this.svrChannel.close();
                }
                catch (IOException ioe) {
                    log.debug("Error closing channel that might be closed: {}", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverSelected(SelectionKey key) {
        if (!key.isValid()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Server selected: a = {}", (Object)key.isAcceptable());
        }
        if (key.isAcceptable()) {
            SocketChannel child = null;
            do {
                try {
                    child = this.svrChannel.accept();
                    if (child == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Accepted new socket {}", (Object)child);
                    }
                    boolean success = false;
                    try {
                        this.runtime.registerCloseable(child);
                        NIOSocketHandle sock = new NIOSocketHandle(this.runtime, child);
                        this.serverConnectionHandler.ioComplete(0, sock);
                        success = true;
                    }
                    finally {
                        if (!success) {
                            this.runtime.unregisterCloseable(child);
                            try {
                                child.close();
                            }
                            catch (IOException ioe) {
                                log.debug("Error closing channel that might be closed: {}", (Throwable)ioe);
                            }
                        }
                    }
                }
                catch (ClosedChannelException cce) {
                    log.debug("Server channel has been closed");
                    break;
                }
                catch (IOException ioe) {
                    log.error("Error accepting a new socket: {}", (Throwable)ioe);
                }
                catch (OSException ose) {
                    log.error("Error accepting a new socket: {}", (Throwable)ose);
                }
            } while (child != null);
        }
    }

    @Override
    public int write(ByteBuffer buf, IOCompletionHandler<Integer> handler) {
        AbstractNIOHandle.QueuedWrite qw = new AbstractNIOHandle.QueuedWrite(buf, handler);
        this.offerWrite(qw);
        return qw.length;
    }

    @Override
    public void shutdown(IOCompletionHandler<Integer> handler) {
        AbstractNIOHandle.QueuedWrite qw = new AbstractNIOHandle.QueuedWrite(null, handler);
        qw.setShutdown(true);
        this.offerWrite(qw);
    }

    private void offerWrite(AbstractNIOHandle.QueuedWrite qw) {
        if (this.writeQueue.isEmpty() && !qw.shutdown) {
            int written;
            try {
                written = this.clientChannel.write(qw.buf);
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("Write error: {}", (Object)ioe.toString());
                }
                if (qw.getHandler() != null) {
                    qw.getHandler().ioComplete(-5, 0);
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Wrote {} to {} from {}", new Object[]{written, this.clientChannel, qw.buf});
            }
            if (qw.buf.hasRemaining()) {
                this.writeReady = false;
                this.queueWrite(qw);
            } else {
                qw.getHandler().ioComplete(0, qw.getLength());
            }
        } else {
            this.queueWrite(qw);
        }
    }

    @Override
    public int getWritesOutstanding() {
        return this.queuedBytes;
    }

    @Override
    public void startReading(IOCompletionHandler<ByteBuffer> handler) {
        if (!this.readStarted) {
            this.readHandler = handler;
            this.addInterest(1);
            this.readStarted = true;
        }
    }

    @Override
    public void stopReading() {
        if (this.readStarted) {
            this.removeInterest(1);
            this.readStarted = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void connect(String host, int port, IOCompletionHandler<Integer> handler) throws OSException {
        boolean success = false;
        SocketChannel newChannel = null;
        try {
            InetSocketAddress targetAddress = new InetSocketAddress(host, port);
            NetworkPolicy netPolicy = this.getNetworkPolicy();
            if (netPolicy != null && !netPolicy.allowConnection(targetAddress)) {
                log.debug("Disallowed connection to {} due to network policy", (Object)targetAddress);
                throw new OSException(-22);
            }
            newChannel = SocketChannel.open();
            if (this.boundAddress != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Client binding locally to {}", (Object)this.boundAddress);
                }
                newChannel.bind(this.boundAddress);
            }
            this.runtime.registerCloseable(newChannel);
            this.clientChannel = newChannel;
            this.clientInit();
            this.clientConnectionHandler = handler;
            if (log.isDebugEnabled()) {
                log.debug("Client connecting to {}:{}", (Object)host, (Object)port);
            }
            boolean connected = newChannel.connect(targetAddress);
            int interest = 0;
            if (connected) {
                log.debug("Client connected immediately");
                interest = 4;
                this.runtime.executeScriptTask(new Runnable(){

                    @Override
                    public void run() {
                        NIOSocketHandle.this.clientConnectionHandler.ioComplete(0, 0);
                    }
                }, null);
            } else {
                interest = 8;
            }
            if (log.isDebugEnabled()) {
                log.debug("Registering socket with interest {}", (Object)interest);
            }
            this.selKey = newChannel.register(this.runtime.getSelector(), interest, new SelectorHandler(){

                @Override
                public void selected(SelectionKey key) {
                    NIOSocketHandle.this.clientSelected(key);
                }
            });
            success = true;
            if (success) return;
            if (newChannel == null) return;
            this.runtime.unregisterCloseable(newChannel);
        }
        catch (IOException ioe) {
            try {
                log.debug("Error on connect: {}", (Throwable)ioe);
                throw new OSException(-5);
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                if (newChannel == null) throw throwable;
                this.runtime.unregisterCloseable(newChannel);
                try {
                    newChannel.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    log.debug("Error closing channel that might be closed: {}", (Throwable)ioe2);
                }
                throw throwable;
            }
        }
        try {
            newChannel.close();
            return;
        }
        catch (IOException ioe) {
            log.debug("Error closing channel that might be closed: {}", (Throwable)ioe);
            return;
        }
    }

    @Override
    protected void processConnect() {
        try {
            this.removeInterest(8);
            this.addInterest(4);
            this.clientChannel.finishConnect();
            if (log.isDebugEnabled()) {
                log.debug("Client {} connected", (Object)this.clientChannel);
            }
            this.clientConnectionHandler.ioComplete(0, 0);
        }
        catch (ConnectException ce) {
            if (log.isDebugEnabled()) {
                log.debug("Error completing connect: {}", (Throwable)ce);
            }
            this.clientConnectionHandler.ioComplete(-61, 0);
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("Error completing connect: {}", (Throwable)ioe);
            }
            this.clientConnectionHandler.ioComplete(-5, 0);
        }
    }

    @Override
    protected void processWrites() {
        AbstractNIOHandle.QueuedWrite qw;
        this.writeReady = true;
        this.removeInterest(4);
        while ((qw = (AbstractNIOHandle.QueuedWrite)this.writeQueue.pollFirst()) != null) {
            this.queuedBytes -= qw.getLength();
            assert (this.queuedBytes >= 0);
            try {
                if (qw.shutdown) {
                    if (log.isDebugEnabled()) {
                        log.debug("Sending shutdown for {}", (Object)this.clientChannel);
                    }
                    this.clientChannel.socket().shutdownOutput();
                    qw.getHandler().ioComplete(0, 0);
                    continue;
                }
                int written = this.clientChannel.write(qw.buf);
                if (log.isDebugEnabled()) {
                    log.debug("Wrote {} to {} from {}", new Object[]{written, this.clientChannel, qw.buf});
                }
                if (qw.buf.hasRemaining()) {
                    this.writeReady = false;
                    this.writeQueue.addFirst(qw);
                    this.queuedBytes += qw.getLength();
                    this.addInterest(4);
                    break;
                }
                qw.getHandler().ioComplete(0, qw.getLength());
            }
            catch (ClosedChannelException cce) {
                if (log.isDebugEnabled()) {
                    log.debug("Channel is closed");
                }
                qw.getHandler().ioComplete(-99, 0);
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("Error on write: {}", (Throwable)ioe);
                }
                qw.getHandler().ioComplete(-5, 0);
            }
        }
    }

    @Override
    protected void processReads() {
        int read;
        if (!this.readStarted) {
            return;
        }
        do {
            try {
                read = this.clientChannel.read(this.readBuffer);
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("Error reading from channel: {}", (Object)ioe, (Object)ioe);
                }
                read = -1;
            }
            if (log.isDebugEnabled()) {
                log.debug("Read {} bytes from {} into {}", new Object[]{read, this.clientChannel, this.readBuffer});
            }
            if (read > 0) {
                this.readBuffer.flip();
                ByteBuffer buf = ByteBuffer.allocate(this.readBuffer.remaining());
                buf.put(this.readBuffer);
                buf.flip();
                this.readBuffer.clear();
                this.readHandler.ioComplete(0, buf);
                continue;
            }
            if (read >= 0) continue;
            this.removeInterest(1);
            this.readHandler.ioComplete(-99, null);
        } while (this.readStarted && read > 0);
    }

    @Override
    public InetSocketAddress getSockName() {
        if (this.svrChannel == null) {
            return (InetSocketAddress)this.clientChannel.socket().getLocalSocketAddress();
        }
        return (InetSocketAddress)this.svrChannel.socket().getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getPeerName() {
        if (this.clientChannel == null) {
            return null;
        }
        return (InetSocketAddress)this.clientChannel.socket().getRemoteSocketAddress();
    }

    @Override
    public void setNoDelay(boolean nd) throws OSException {
        if (this.clientChannel != null) {
            try {
                this.clientChannel.socket().setTcpNoDelay(nd);
            }
            catch (SocketException e) {
                log.error("Error setting TCP no delay on {}: {}", (Object)this, (Object)e);
                throw new OSException(-5);
            }
        }
    }

    @Override
    public void setKeepAlive(boolean nd) throws OSException {
        if (this.clientChannel != null) {
            try {
                this.clientChannel.socket().setKeepAlive(nd);
            }
            catch (SocketException e) {
                log.error("Error setting TCP keep alive on {}: {}", (Object)this, (Object)e);
                throw new OSException(-5);
            }
        }
    }
}

