/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.handles;

import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class JavaOutputStreamHandle
extends AbstractHandle {
    private final OutputStream out;

    public JavaOutputStreamHandle(OutputStream out) {
        this.out = out;
    }

    @Override
    public int write(ByteBuffer buf, IOCompletionHandler<Integer> handler) {
        try {
            int len = buf.remaining();
            if (buf.hasArray()) {
                this.out.write(buf.array(), buf.arrayOffset() + buf.position(), len);
                buf.position(buf.position() + len);
            } else {
                byte[] tmp = new byte[len];
                buf.get(tmp);
                this.out.write(tmp);
            }
            handler.ioComplete(0, len);
            return len;
        }
        catch (IOException ioe) {
            handler.ioComplete(-5, 0);
            return 0;
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

