/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.handles;

import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.net.NetworkPolicy;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.ArrayDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNIOHandle
extends AbstractHandle {
    private static final Logger log = LoggerFactory.getLogger(AbstractNIOHandle.class);
    protected final GenericNodeRuntime runtime;
    protected SelectionKey selKey;
    protected boolean writeReady;
    protected final ArrayDeque<QueuedWrite> writeQueue = new ArrayDeque();
    protected int queuedBytes;

    protected AbstractNIOHandle(GenericNodeRuntime runtime) {
        this.runtime = runtime;
    }

    protected NetworkPolicy getNetworkPolicy() {
        return this.runtime.getNetworkPolicy();
    }

    protected void addInterest(int i) {
        this.selKey.interestOps(this.selKey.interestOps() | i);
        if (log.isDebugEnabled()) {
            log.debug("Interest now {}", (Object)this.selKey.interestOps());
        }
    }

    protected void removeInterest(int i) {
        if (this.selKey.isValid()) {
            this.selKey.interestOps(this.selKey.interestOps() & ~i);
            if (log.isDebugEnabled()) {
                log.debug("Interest now {}", (Object)this.selKey.interestOps());
            }
        }
    }

    protected void queueWrite(QueuedWrite qw) {
        this.addInterest(4);
        this.writeQueue.addLast(qw);
        this.queuedBytes += qw.getLength();
    }

    protected void clientSelected(SelectionKey key) {
        if (log.isDebugEnabled()) {
            log.debug("Client selected: interest = {} r = {} w = {} c = {}", new Object[]{this.selKey.interestOps(), key.isReadable(), key.isWritable(), key.isConnectable()});
        }
        if (key.isValid() && key.isConnectable()) {
            this.processConnect();
        }
        if (key.isValid() && (key.isWritable() || this.writeReady)) {
            this.processWrites();
        }
        if (key.isValid() && key.isReadable()) {
            this.processReads();
        }
    }

    protected abstract void processConnect();

    protected abstract void processWrites();

    protected abstract void processReads();

    public static class QueuedWrite {
        ByteBuffer buf;
        int length;
        IOCompletionHandler<Integer> handler;
        Object context;
        boolean shutdown;
        SocketAddress address;

        public QueuedWrite(ByteBuffer buf, IOCompletionHandler<Integer> handler) {
            this.buf = buf;
            this.length = buf == null ? 0 : buf.remaining();
            this.handler = handler;
        }

        public ByteBuffer getBuf() {
            return this.buf;
        }

        public void setBuf(ByteBuffer buf) {
            this.buf = buf;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public IOCompletionHandler<Integer> getHandler() {
            return this.handler;
        }

        public void setListener(IOCompletionHandler<Integer> handler) {
            this.handler = handler;
        }

        public Object getContext() {
            return this.context;
        }

        public void setContext(Object context) {
            this.context = context;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }

        public void setShutdown(boolean shutdown) {
            this.shutdown = shutdown;
        }

        public SocketAddress getAddress() {
            return this.address;
        }

        public void setAddress(SocketAddress address) {
            this.address = address;
        }
    }
}

