/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.fs;

import java.io.File;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Map;
import java.util.Set;

public class FileStats {
    private long size;
    private long atime;
    private long mtime;
    private long ctime;
    private int dev;
    private int ino;
    private int nlink;
    private int uid;
    private int gid;
    private int mode;

    public FileStats() {
    }

    public FileStats(File file) {
        this.nlink = 1;
        this.size = file.length();
        this.mtime = this.ctime = file.lastModified();
        this.atime = this.ctime;
        this.mode = 0;
        if (file.isDirectory()) {
            this.mode |= 0x4000;
        }
        if (file.isFile()) {
            this.mode |= 0x8000;
        }
        if (file.canRead()) {
            this.mode |= 0x100;
        }
        if (file.canWrite()) {
            this.mode |= 0x80;
        }
        if (file.canExecute()) {
            this.mode |= 0x40;
        }
    }

    public FileStats(File file, Map<String, Object> attrs) {
        this.nlink = 1;
        this.size = ((Number)attrs.get("size")).longValue();
        Object ino = attrs.get("fileKey");
        if (ino instanceof Number) {
            this.ino = ((Number)ino).intValue();
        } else if (ino != null) {
            this.ino = ino.hashCode();
        }
        this.atime = ((FileTime)attrs.get("lastAccessTime")).toMillis();
        this.mtime = ((FileTime)attrs.get("lastModifiedTime")).toMillis();
        this.ctime = ((FileTime)attrs.get("creationTime")).toMillis();
        if (attrs.containsKey("owner")) {
            UserPrincipal up = (UserPrincipal)attrs.get("owner");
            this.uid = up.hashCode();
        }
        if (attrs.containsKey("group")) {
            GroupPrincipal gp = (GroupPrincipal)attrs.get("group");
            this.gid = gp.hashCode();
        }
        if (((Boolean)attrs.get("isRegularFile")).booleanValue()) {
            this.mode |= 0x8000;
        }
        if (((Boolean)attrs.get("isDirectory")).booleanValue()) {
            this.mode |= 0x4000;
        }
        if (((Boolean)attrs.get("isSymbolicLink")).booleanValue()) {
            this.mode |= 0xA000;
        }
        if (attrs.containsKey("permissions")) {
            Set perms = (Set)attrs.get("permissions");
            this.mode |= this.setPosixPerms(perms);
        } else {
            this.mode |= this.setNonPosixPerms(file);
        }
    }

    public int setPosixPerms(Set<PosixFilePermission> perms) {
        int mode = 0;
        if (perms.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mode |= 8;
        }
        if (perms.contains((Object)PosixFilePermission.GROUP_READ)) {
            mode |= 0x20;
        }
        if (perms.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mode |= 0x10;
        }
        if (perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mode |= 1;
        }
        if (perms.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mode |= 4;
        }
        if (perms.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mode |= 2;
        }
        if (perms.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mode |= 0x40;
        }
        if (perms.contains((Object)PosixFilePermission.OWNER_READ)) {
            mode |= 0x100;
        }
        if (perms.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mode |= 0x80;
        }
        return mode;
    }

    public int setNonPosixPerms(File file) {
        int mode = 0;
        if (file.canRead()) {
            mode |= 0x100;
        }
        if (file.canWrite()) {
            mode |= 0x80;
        }
        if (file.canExecute()) {
            mode |= 0x40;
        }
        return mode;
    }

    public long getSize() {
        return this.size;
    }

    public long getAtime() {
        return this.atime;
    }

    public long getMtime() {
        return this.mtime;
    }

    public long getCtime() {
        return this.ctime;
    }

    public int getDev() {
        return this.dev;
    }

    public int getIno() {
        return this.ino;
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public int getMode() {
        return this.mode;
    }

    public int getNLink() {
        return this.nlink;
    }

    public boolean equals(Object o) {
        try {
            FileStats s = (FileStats)o;
            return this.atime == s.atime && this.mtime == s.mtime && this.ctime == s.ctime && this.dev == s.dev && this.gid == s.gid && this.ino == s.ino && this.mode == s.mode && this.size == s.size && this.uid == s.uid;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return (int)this.size + this.mode + this.ino;
    }
}

