/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.dns;

import io.apigee.trireme.kernel.dns.DNSFormatException;
import io.apigee.trireme.kernel.dns.Decompressor;
import io.apigee.trireme.kernel.dns.Wire;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;

public class Types {
    private static final Charset UTF8 = Charset.forName("UTF8");
    public static final int CLASS_IN = 1;
    public static final int TYPE_A = 1;
    public static final int TYPE_AAAA = 28;
    public static final int TYPE_CNAME = 5;
    public static final int TYPE_MX = 15;
    public static final int TYPE_NS = 2;
    public static final int TYPE_PTR = 12;
    public static final int TYPE_TXT = 16;
    public static final int TYPE_SRV = 33;
    public static final int TYPE_NAPTR = 35;
    private static final Types myself = new Types();
    private final HashMap<String, Integer> typeCodes = new HashMap();

    public static Types get() {
        return myself;
    }

    private Types() {
        this.typeCodes.put("A", 1);
        this.typeCodes.put("AAAA", 28);
        this.typeCodes.put("CNAME", 5);
        this.typeCodes.put("MX", 15);
        this.typeCodes.put("NAPTR", 35);
        this.typeCodes.put("NS", 2);
        this.typeCodes.put("PTR", 12);
        this.typeCodes.put("SRV", 33);
        this.typeCodes.put("TXT", 16);
    }

    public int getTypeCode(String type) {
        Integer code = this.typeCodes.get(type);
        return code == null ? -1 : code;
    }

    public Object parseRecord(Wire.RR rec) throws DNSFormatException {
        Object result;
        switch (rec.getType()) {
            case 1: {
                result = this.parseA(rec.getData());
                break;
            }
            case 28: {
                result = this.parseAaaa(rec.getData());
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                result = this.parseName(rec.getData());
                break;
            }
            case 15: {
                result = this.parseMx(rec.getData());
                break;
            }
            case 16: {
                result = this.parseTxt(rec.getData());
                break;
            }
            case 33: {
                result = this.parseSrv(rec.getData());
                break;
            }
            case 35: {
                result = this.parseNaptr(rec.getData());
                break;
            }
            default: {
                throw new DNSFormatException("Invalid record type " + rec.getType());
            }
        }
        rec.setResult(result);
        return result;
    }

    private InetAddress parseA(ByteBuffer buf) throws DNSFormatException {
        if (buf.remaining() < 4) {
            throw new DNSFormatException("Unexpected EOM in A record");
        }
        try {
            byte[] addr = new byte[4];
            buf.get(addr);
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException uhe) {
            throw new DNSFormatException("Invalid address in A record: " + uhe);
        }
    }

    private InetAddress parseAaaa(ByteBuffer buf) throws DNSFormatException {
        if (buf.remaining() < 16) {
            throw new DNSFormatException("Unexpected EOM in A record");
        }
        try {
            byte[] addr = new byte[16];
            buf.get(addr);
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException uhe) {
            throw new DNSFormatException("Invalid address in A record: " + uhe);
        }
    }

    private String parseName(ByteBuffer buf) throws DNSFormatException {
        Decompressor dcomp = new Decompressor();
        return dcomp.readName(buf);
    }

    private String parseTxt(ByteBuffer buf) {
        String s;
        Decompressor dcomp = new Decompressor();
        StringBuilder sb = new StringBuilder();
        do {
            if ((s = dcomp.readCharacterString(buf)) == null) continue;
            sb.append(s);
        } while (s != null && buf.hasRemaining());
        return sb.toString();
    }

    private Mx parseMx(ByteBuffer buf) throws DNSFormatException {
        Decompressor dcomp = new Decompressor();
        if (buf.remaining() < 2) {
            throw new DNSFormatException("Unexpected EOM in MX record");
        }
        Mx mx = new Mx();
        mx.setPreference(buf.getShort() & 0xFFFF);
        mx.setExchange(dcomp.readName(buf));
        return mx;
    }

    private Srv parseSrv(ByteBuffer buf) throws DNSFormatException {
        Decompressor dcomp = new Decompressor();
        Srv s = new Srv();
        s.setPriority(buf.getShort() & 0xFFFF);
        s.setWeight(buf.getShort() & 0xFFFF);
        s.setPort(buf.getShort() & 0xFFFF);
        s.setTarget(dcomp.readName(buf));
        return s;
    }

    private Naptr parseNaptr(ByteBuffer buf) throws DNSFormatException {
        Decompressor dcomp = new Decompressor();
        Naptr n = new Naptr();
        n.setOrder(buf.getShort() & 0xFFFF);
        n.setPreference(buf.getShort() & 0xFFFF);
        n.setFlags(dcomp.readCharacterString(buf));
        n.setService(dcomp.readCharacterString(buf));
        n.setRegexp(dcomp.readCharacterString(buf));
        n.setReplacement(dcomp.readName(buf));
        return n;
    }

    public static class Naptr {
        private int order;
        private int preference;
        private String flags;
        private String service;
        private String regexp;
        private String replacement;

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public int getPreference() {
            return this.preference;
        }

        public void setPreference(int preference) {
            this.preference = preference;
        }

        public String getFlags() {
            return this.flags;
        }

        public void setFlags(String flags) {
            this.flags = flags;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public void setRegexp(String regexp) {
            this.regexp = regexp;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }
    }

    public static class Srv {
        private int priority;
        private int weight;
        private int port;
        private String target;

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }

    public static class Mx {
        private int preference;
        private String exchange;

        public int getPreference() {
            return this.preference;
        }

        public void setPreference(int p) {
            this.preference = p;
        }

        public String getExchange() {
            return this.exchange;
        }

        public void setExchange(String e) {
            this.exchange = e;
        }
    }
}

