/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.dns;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSConfig {
    private static final Logger log = LoggerFactory.getLogger(DNSConfig.class);
    private static final Pattern NAMESERVER_PATTERN = Pattern.compile("^nameserver[\\s]+([\\S]+)");
    private static final DNSConfig myself = new DNSConfig();
    private final ArrayList<String> servers = new ArrayList();

    public static DNSConfig get() {
        return myself;
    }

    private DNSConfig() {
        String servers = System.getProperty("TRIREME_DNS_SERVERS");
        if (servers != null) {
            this.readProperty(servers);
        } else {
            this.readResolvConf();
        }
    }

    public List<String> getServers() {
        return this.servers;
    }

    private boolean readResolvConf() {
        File resolvConf = new File("/etc/resolv.conf");
        if (!(resolvConf.exists() && resolvConf.isFile() && resolvConf.canRead())) {
            log.debug("Cannot open /eyc/resolv.conf.");
            return false;
        }
        try {
            String line;
            FileInputStream in = new FileInputStream(resolvConf);
            BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
            do {
                Matcher m;
                if ((line = rdr.readLine()) == null || !(m = NAMESERVER_PATTERN.matcher(line)).matches()) continue;
                String server = m.group(1);
                if (log.isDebugEnabled()) {
                    log.debug("Found name server {}", (Object)server);
                }
                this.servers.add(server);
            } while (line != null);
            return true;
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("Error reading /etc/resolv.conf: " + ioe);
            }
            return false;
        }
    }

    private boolean readProperty(String prop) {
        String[] sl;
        for (String s : sl = prop.split(",")) {
            this.servers.add(s);
        }
        return true;
    }
}

