/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.crypto;

import io.apigee.trireme.kernel.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class SignatureAlgorithms {
    private static final SignatureAlgorithms myself = new SignatureAlgorithms();
    private final HashMap<String, Algorithm> algs = new HashMap();
    private final HashMap<String, Algorithm> javaSigningAlgs = new HashMap();
    private final ArrayList<String> algNames = new ArrayList();

    public static SignatureAlgorithms get() {
        return myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignatureAlgorithms() {
        Pattern WHITESPACE = Pattern.compile("[\\t ]+");
        Set<String> supportedAlgorithms = Security.getAlgorithms("Signature");
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(SignatureAlgorithms.class.getResourceAsStream("/signatures.txt"), Charsets.UTF8));){
            String line;
            do {
                String[] m;
                if ((line = rdr.readLine()) == null || line.startsWith("#") || (m = WHITESPACE.split(line)).length != 3 || !supportedAlgorithms.contains(m[1])) continue;
                Algorithm alg = new Algorithm();
                alg.setName(m[0].toUpperCase());
                alg.setSigningName(m[1].toUpperCase());
                alg.setKeyFormat(m[2]);
                this.algNames.add(m[0]);
                this.algs.put(m[0].toUpperCase(), alg);
                this.javaSigningAlgs.put(m[1], alg);
            } while (line != null);
        }
        catch (IOException ioe) {
            throw new AssertionError("Can't read hashes file", ioe);
        }
        catch (NumberFormatException nfe) {
            throw new AssertionError("Invalid line in hashes file", nfe);
        }
        Collections.sort(this.algNames);
    }

    public Algorithm get(String name) {
        return this.algs.get(name.toUpperCase());
    }

    public Algorithm getByJavaSigningName(String name) {
        return this.javaSigningAlgs.get(name);
    }

    public List<String> getAlgorithms() {
        return this.algNames;
    }

    public static class Algorithm {
        private String name;
        private String signName;
        private String keyFormat;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSigningName() {
            return this.signName;
        }

        public void setSigningName(String signName) {
            this.signName = signName;
        }

        public String getKeyFormat() {
            return this.keyFormat;
        }

        public void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }
    }
}

