/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.crypto;

import io.apigee.trireme.kernel.Charsets;
import io.apigee.trireme.kernel.crypto.SignatureAlgorithms;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class HashAlgorithms {
    private static final HashAlgorithms myself = new HashAlgorithms();
    private final HashMap<String, Algorithm> algs = new HashMap();
    private final HashMap<String, Algorithm> javaHashAlgs = new HashMap();
    private final ArrayList<String> algNames = new ArrayList();

    public static HashAlgorithms get() {
        return myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashAlgorithms() {
        Pattern WHITESPACE = Pattern.compile("[\\t ]+");
        Set<String> supportedAlgorithms = Security.getAlgorithms("MessageDigest");
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(SignatureAlgorithms.class.getResourceAsStream("/hashes.txt"), Charsets.UTF8));){
            String line;
            do {
                String[] m;
                if ((line = rdr.readLine()) == null || line.startsWith("#") || (m = WHITESPACE.split(line)).length != 2 || !supportedAlgorithms.contains(m[1])) continue;
                Algorithm alg = new Algorithm();
                alg.setName(m[0].toUpperCase());
                alg.setHashName(m[1]);
                this.algNames.add(m[0]);
                this.algs.put(m[0].toUpperCase(), alg);
                this.javaHashAlgs.put(m[1], alg);
            } while (line != null);
        }
        catch (IOException ioe) {
            throw new AssertionError("Can't read hashes file", ioe);
        }
        catch (NumberFormatException nfe) {
            throw new AssertionError("Invalid line in hashes file", nfe);
        }
        Collections.sort(this.algNames);
    }

    public Algorithm get(String name) {
        return this.algs.get(name.toUpperCase());
    }

    public Algorithm getByJavaHashName(String name) {
        return this.javaHashAlgs.get(name);
    }

    public List<String> getAlgorithms() {
        return this.algNames;
    }

    public static class Algorithm {
        private String name;
        private String hashName;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHashName() {
            return this.hashName;
        }

        public void setHashName(String hashName) {
            this.hashName = hashName;
        }
    }
}

