/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.crypto;

import io.apigee.trireme.kernel.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.crypto.Cipher;

public class CryptoAlgorithms {
    private static final String PADDING = "/PKCS5Padding";
    private static final String NO_PADDING = "/NoPadding";
    private static final Pattern WHITESPACE = Pattern.compile("[\\t ]+");
    private final HashMap<String, Spec> Ciphers = new HashMap();
    private final ArrayList<String> CipherNames;
    private static final CryptoAlgorithms myself = new CryptoAlgorithms();

    public static CryptoAlgorithms get() {
        return myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CryptoAlgorithms() {
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(CryptoAlgorithms.class.getResourceAsStream("/ciphers.txt"), Charsets.UTF8));){
            String line;
            do {
                int ivLen;
                int keyLen;
                Spec s;
                String[] m;
                if ((line = rdr.readLine()) == null || line.startsWith("#") || (m = WHITESPACE.split(line)).length != 5 || !CryptoAlgorithms.isSupported((s = new Spec(m[1], m[2], (keyLen = Integer.parseInt(m[3])) / 8, ivLen = Integer.parseInt(m[4]))).getName(), keyLen)) continue;
                this.Ciphers.put(m[0], s);
            } while (line != null);
        }
        catch (IOException ioe) {
            throw new AssertionError("Can't read ciphers file", ioe);
        }
        catch (NumberFormatException nfe) {
            throw new AssertionError("Invalid line in ciphers file", nfe);
        }
        this.CipherNames = new ArrayList<String>(this.Ciphers.keySet());
        Collections.sort(this.CipherNames);
    }

    private static boolean isSupported(String name, int keyLen) {
        try {
            int maxKeyLen = Cipher.getMaxAllowedKeyLength(name + PADDING);
            return keyLen <= maxKeyLen;
        }
        catch (NoSuchAlgorithmException nse) {
            return false;
        }
    }

    public Spec getAlgorithm(String name) {
        return this.Ciphers.get(name.toLowerCase());
    }

    public List<String> getCiphers() {
        return this.CipherNames;
    }

    public static final class Spec {
        private final String name;
        private final String algo;
        private final int keyLen;
        private final int ivLen;

        Spec(String name, String algo, int keyLen, int ivLen) {
            this.name = name;
            this.algo = algo;
            this.keyLen = keyLen;
            this.ivLen = ivLen;
        }

        public String getName() {
            return this.name;
        }

        public String getAlgo() {
            return this.algo;
        }

        public int getKeyLen() {
            return this.keyLen;
        }

        public int getIvLen() {
            return this.ivLen;
        }

        public String getFullName(boolean padding) {
            return this.name + (padding ? CryptoAlgorithms.PADDING : CryptoAlgorithms.NO_PADDING);
        }

        public String toString() {
            return this.algo + ": " + this.name + " key = " + this.keyLen + " iv = " + this.ivLen;
        }
    }
}

