/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.charsets;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class HexCharset
extends Charset {
    public static final String NAME = "Node-Hex";

    public HexCharset() {
        super(NAME, null);
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof HexCharset;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Dec(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Enc(this);
    }

    private static final class Dec
    extends CharsetDecoder {
        private static final char[] encoding = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        Dec(Charset c) {
            super(c, 2.0f, 2.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                if (out.remaining() < 2) {
                    return CoderResult.OVERFLOW;
                }
                byte val = in.get();
                out.put(encoding[val >> 4 & 0xF]);
                out.put(encoding[val & 0xF]);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private static final class Enc
    extends CharsetEncoder {
        private char leftover;
        private boolean hasLeftover;

        Enc(Charset c) {
            super(c, 0.5f, 1.0f);
        }

        @Override
        protected void implReset() {
            this.hasLeftover = false;
        }

        @Override
        public boolean canEncode(char c) {
            return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || Character.isDigit(c);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining() && (this.hasLeftover || in.remaining() >= 2)) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char[] nv = new char[]{this.hasLeftover ? this.leftover : in.get(), in.get()};
                this.hasLeftover = false;
                String nvs = new String(nv);
                out.put((byte)(Integer.parseInt(nvs, 16) & 0xFF));
            }
            if (in.hasRemaining()) {
                this.leftover = in.get();
                this.hasLeftover = true;
            }
            assert (!in.hasRemaining());
            return CoderResult.UNDERFLOW;
        }
    }
}

