/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel;

import io.apigee.trireme.kernel.ErrorCodes;

public class OSException
extends Exception {
    private final int code;
    private String path;

    public OSException(int code) {
        super(ErrorCodes.get().toString(code));
        this.code = code;
    }

    public OSException(int code, String path) {
        super(ErrorCodes.get().toString(code) + ':' + path);
        this.code = code;
        this.path = path;
    }

    public OSException(int code, Throwable cause) {
        super(ErrorCodes.get().toString(code));
        this.code = code;
        this.initCause(cause);
    }

    public OSException(int code, Throwable cause, String path) {
        super(ErrorCodes.get().toString(code) + ':' + path);
        this.code = code;
        this.path = path;
        this.initCause(cause);
    }

    public int getCode() {
        return this.code;
    }

    public String getStringCode() {
        return ErrorCodes.get().toString(this.code);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

