/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.zip;

import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.util.GZipHeader;
import io.apigee.trireme.kernel.zip.ZlibWriter;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decompressor
extends ZlibWriter {
    private static final Logger log = LoggerFactory.getLogger(Decompressor.class);
    private Inflater inflater;
    private GZipHeader header;
    private final ByteBuffer dictionary;
    private CRC32 checksum;

    public Decompressor(int mode, ByteBuffer dictionary) throws OSException {
        super(mode);
        this.dictionary = dictionary;
    }

    public void setParams(int level, int strategy) {
    }

    public void reset() {
        this.inflater.reset();
        if (this.checksum != null) {
            this.checksum.reset();
        }
    }

    public void write(int flush, ByteBuffer in, ByteBuffer out) throws DataFormatException {
        int len;
        int off;
        byte[] buf;
        if (log.isDebugEnabled()) {
            log.debug("Deflating from {} into {}", (Object)in, (Object)out);
        }
        if (log.isDebugEnabled()) {
            log.debug("Inflating {} into {} flush = {}", new Object[]{in, out, flush});
        }
        if (this.inflater == null) {
            this.initInflater(in);
            if (this.inflater == null) {
                return;
            }
        }
        if (this.mode == 3) {
            if (this.header == null) {
                this.header = GZipHeader.load(in);
                if (this.header == null) {
                    return;
                }
                this.checksum = new CRC32();
            } else if (this.inflater.finished()) {
                if (in.remaining() >= 8) {
                    this.checkTrailer(in);
                } else {
                    return;
                }
            }
        }
        this.addInput(in);
        if (out.hasArray()) {
            buf = out.array();
            off = out.arrayOffset() + out.position();
            len = out.remaining();
        } else {
            buf = new byte[out.remaining()];
            out.duplicate().get(buf);
            off = 0;
            len = out.remaining();
        }
        long oldPos = this.inflater.getBytesRead();
        int numWritten = this.inflater.inflate(buf, off, len);
        long numRead = this.inflater.getBytesRead() - oldPos;
        if (log.isDebugEnabled()) {
            log.debug("Inflater: read {}, wrote {}", (Object)numRead, (Object)numWritten);
        }
        if (this.mode == 3) {
            this.checksum.update(buf, off, numWritten);
        }
        if (in != null) {
            in.position(in.position() + (int)numRead);
        }
        out.position(out.position() + numWritten);
        if (numWritten == 0 && this.inflater.needsDictionary()) {
            if (this.dictionary == null) {
                throw new DataFormatException("Missing dictionary");
            }
            this.addDictionary();
            this.write(flush, null, out);
            return;
        }
        if (this.mode == 3 && this.inflater.finished() && in.remaining() >= 8) {
            this.checkTrailer(in);
        }
    }

    private void initInflater(ByteBuffer in) throws DataFormatException {
        switch (this.mode) {
            case 1: {
                this.inflater = new Inflater();
                break;
            }
            case 5: {
                this.inflater = new Inflater(true);
                break;
            }
            case 3: {
                this.inflater = new Inflater(true);
                break;
            }
            case 6: {
                GZipHeader.Magic magic = GZipHeader.peekMagicNumber(in);
                if (magic == GZipHeader.Magic.GZIP) {
                    this.mode = 3;
                    this.inflater = new Inflater(true);
                    break;
                }
                if (magic == GZipHeader.Magic.UNDEFINED) {
                    this.mode = 1;
                    this.inflater = new Inflater();
                    break;
                }
                return;
            }
            default: {
                throw new DataFormatException("Invalid mode " + this.mode + " for decompression");
            }
        }
    }

    private void addInput(ByteBuffer in) {
        int off;
        int len;
        byte[] buf;
        if (in == null) {
            buf = null;
            len = 0;
            off = 0;
        } else if (in.hasArray()) {
            buf = in.array();
            off = in.arrayOffset() + in.position();
            len = in.remaining();
        } else {
            buf = new byte[in.remaining()];
            in.duplicate().get(buf);
            off = 0;
            len = in.remaining();
        }
        if (buf != null) {
            this.inflater.setInput(buf, off, len);
        }
    }

    private void addDictionary() throws DataFormatException {
        if (log.isDebugEnabled()) {
            log.debug("Adding dictionary {}", (Object)this.dictionary);
        }
        try {
            if (this.dictionary.hasArray()) {
                this.inflater.setDictionary(this.dictionary.array(), this.dictionary.arrayOffset() + this.dictionary.position(), this.dictionary.remaining());
            } else {
                byte[] dict = new byte[this.dictionary.remaining()];
                this.dictionary.get(dict);
                this.inflater.setDictionary(dict);
            }
        }
        catch (IllegalArgumentException ie) {
            throw new DataFormatException("Bad dictionary: " + ie.getMessage());
        }
    }

    private void checkTrailer(ByteBuffer in) throws DataFormatException {
        GZipHeader.Trailer trailer = GZipHeader.readGZipTrailer(in);
        if (trailer.getLength() != this.inflater.getBytesWritten()) {
            throw new DataFormatException("GZip length does not match");
        }
        if (trailer.getChecksum() != this.checksum.getValue()) {
            throw new DataFormatException("GZip checksum does not match");
        }
    }

    public void close() {
        if (this.inflater != null) {
            this.inflater.end();
        }
    }
}

