/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.zip;

import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.util.GZipHeader;
import io.apigee.trireme.kernel.zip.ZlibWriter;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compressor
extends ZlibWriter {
    private static final Logger log = LoggerFactory.getLogger(Compressor.class);
    protected final Deflater deflater;
    private ByteBuffer header;
    private ByteBuffer trailer;
    private CRC32 checksum;

    public Compressor(int mode, int level, int strategy, ByteBuffer dictionary) throws OSException {
        super(mode);
        switch (mode) {
            case 0: {
                this.deflater = new Deflater(level);
                break;
            }
            case 4: {
                this.deflater = new Deflater(level, true);
                break;
            }
            case 2: {
                this.deflater = new Deflater(level, true);
                GZipHeader hdr = new GZipHeader();
                hdr.setTimestamp(System.currentTimeMillis());
                hdr.setCompressionLevel(level);
                this.header = hdr.store();
                this.checksum = new CRC32();
                break;
            }
            default: {
                throw new OSException(-22, "Invalid mode " + mode + " for compression");
            }
        }
        this.deflater.setStrategy(strategy);
        if (log.isDebugEnabled()) {
            log.debug("Going to deflate with strategy {}, level {}", (Object)strategy, (Object)level);
        }
        if (dictionary != null) {
            try {
                if (dictionary.hasArray()) {
                    this.deflater.setDictionary(dictionary.array(), dictionary.arrayOffset() + dictionary.position(), dictionary.remaining());
                } else {
                    byte[] dict = new byte[dictionary.remaining()];
                    dictionary.get(dict);
                    this.deflater.setDictionary(dict);
                }
            }
            catch (IllegalArgumentException ie) {
                throw new OSException(-22, "Bad dictionary: " + ie.getMessage());
            }
        }
    }

    public void setParams(int level, int strategy) {
        if (log.isDebugEnabled()) {
            log.debug("Changing deflate paramst to  strategy {}, level {}", (Object)strategy, (Object)level);
        }
        this.deflater.setLevel(level);
        this.deflater.setStrategy(strategy);
    }

    public void reset() {
        this.deflater.reset();
        if (this.checksum != null) {
            this.checksum.reset();
        }
    }

    public void write(int flush, ByteBuffer in, ByteBuffer out) {
        int flushFlag;
        int len;
        int off;
        byte[] buf;
        if (log.isDebugEnabled()) {
            log.debug("Deflating {} into {} flush = {}", new Object[]{in, out, flush});
        }
        if (this.mode == 2) {
            if (this.header != null) {
                out.put(this.header);
                if (this.header.hasRemaining()) {
                    return;
                }
                this.header = null;
            } else if (this.trailer != null) {
                out.put(this.trailer);
                if (!this.trailer.hasRemaining()) {
                    this.trailer = null;
                }
                return;
            }
        }
        if (out.hasArray()) {
            buf = out.array();
            off = out.arrayOffset() + out.position();
            len = out.remaining();
        } else {
            buf = new byte[out.remaining()];
            out.duplicate().get(buf);
            off = 0;
            len = out.remaining();
        }
        this.addInput(in);
        if (flush == 7) {
            flushFlag = 0;
            this.deflater.finish();
        } else {
            flushFlag = flush;
        }
        long oldPos = this.deflater.getBytesRead();
        int numWritten = this.doDeflate(buf, off, len, flushFlag);
        int numRead = (int)(this.deflater.getBytesRead() - oldPos);
        if (log.isDebugEnabled()) {
            log.debug("Deflater: read {}, wrote {}", (Object)numRead, (Object)numWritten);
        }
        in.position(in.position() + numRead);
        out.position(out.position() + numWritten);
        if (this.mode == 2 && this.deflater.finished()) {
            this.trailer = GZipHeader.writeGZipTrailer(this.checksum.getValue(), this.deflater.getBytesRead());
            out.put(this.trailer);
            if (!out.hasRemaining()) {
                this.trailer = null;
            }
        }
    }

    protected int doDeflate(byte[] outBuf, int outOff, int outLen, int flags) {
        return this.deflater.deflate(outBuf, outOff, outLen);
    }

    private void addInput(ByteBuffer in) {
        int off;
        int len;
        byte[] buf;
        if (in == null) {
            buf = null;
            len = 0;
            off = 0;
        } else if (in.hasArray()) {
            buf = in.array();
            off = in.arrayOffset() + in.position();
            len = in.remaining();
        } else {
            buf = new byte[in.remaining()];
            in.duplicate().get(buf);
            off = 0;
            len = in.remaining();
        }
        this.deflater.setInput(buf, off, len);
        if (this.mode == 2) {
            this.checksum.update(buf, off, len);
        }
    }

    public void close() {
        if (this.deflater != null) {
            this.deflater.end();
        }
    }
}

