/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.util;

import io.apigee.trireme.kernel.Charsets;
import io.apigee.trireme.kernel.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern DOUBLE_QUOTED = Pattern.compile("^[\\s]*\"(.*)\"[\\s]*$");
    private static final Pattern SINGLE_QUOTED = Pattern.compile("^[\\s]*'(.*)'[\\s]*$");

    public static String bufferToString(ByteBuffer buf, Charset cs) {
        CoderResult result;
        if (buf.hasArray()) {
            String s = new String(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), cs);
            buf.position(buf.limit());
            return s;
        }
        CharsetDecoder decoder = Charsets.get().getDecoder(cs);
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        int bufLen = (int)((float)buf.limit() * decoder.averageCharsPerByte());
        CharBuffer cBuf = CharBuffer.allocate(bufLen);
        do {
            if (!(result = decoder.decode(buf, cBuf, true)).isOverflow()) continue;
            cBuf = BufferUtils.doubleBuffer(cBuf);
        } while (result.isOverflow());
        do {
            if (!(result = decoder.flush(cBuf)).isOverflow()) continue;
            cBuf = BufferUtils.doubleBuffer(cBuf);
        } while (result.isOverflow());
        cBuf.flip();
        return cBuf.toString();
    }

    public static String bufferToString(ByteBuffer[] bufs, Charset cs) {
        CoderResult result;
        CharsetDecoder decoder = Charsets.get().getDecoder(cs);
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        int totalBytes = 0;
        for (int i = 0; i < bufs.length; ++i) {
            totalBytes += bufs[i] == null ? 0 : bufs[i].remaining();
        }
        int bufLen = (int)((float)totalBytes * decoder.averageCharsPerByte());
        CharBuffer cBuf = CharBuffer.allocate(bufLen);
        for (int i = 0; i < bufs.length; ++i) {
            do {
                if (!(result = decoder.decode(bufs[i], cBuf, i == bufs.length - 1)).isOverflow()) continue;
                cBuf = BufferUtils.doubleBuffer(cBuf);
            } while (result.isOverflow());
        }
        do {
            if (!(result = decoder.flush(cBuf)).isOverflow()) continue;
            cBuf = BufferUtils.doubleBuffer(cBuf);
        } while (result.isOverflow());
        cBuf.flip();
        return cBuf.toString();
    }

    public static ByteBuffer stringToBuffer(String str, Charset cs) {
        if (Charsets.BASE64.equals(cs)) {
            CoderResult result;
            CharsetEncoder enc = Charsets.get().getEncoder(cs);
            enc.onMalformedInput(CodingErrorAction.REPORT);
            enc.onUnmappableCharacter(CodingErrorAction.IGNORE);
            CharBuffer chars = CharBuffer.wrap(str);
            int bufLen = (int)((float)chars.remaining() * enc.averageBytesPerChar());
            ByteBuffer writeBuf = ByteBuffer.allocate(bufLen);
            do {
                if (!(result = enc.encode(chars, writeBuf, true)).isOverflow()) continue;
                writeBuf = BufferUtils.doubleBuffer(writeBuf);
            } while (result.isOverflow());
            do {
                if (!(result = enc.flush(writeBuf)).isOverflow()) continue;
                writeBuf = BufferUtils.doubleBuffer(writeBuf);
            } while (result.isOverflow());
            writeBuf.flip();
            return writeBuf;
        }
        byte[] enc = str.getBytes(cs);
        return ByteBuffer.wrap(enc);
    }

    public static String unquote(String s) {
        Matcher m = DOUBLE_QUOTED.matcher(s);
        if (m.matches()) {
            return m.group(1);
        }
        Matcher m2 = SINGLE_QUOTED.matcher(s);
        if (m2.matches()) {
            return m2.group(1);
        }
        return s;
    }
}

