/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.tls;

import io.apigee.trireme.kernel.BiCallback;
import io.apigee.trireme.kernel.Callback;
import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.TriCallback;
import io.apigee.trireme.kernel.tls.TLSChunk;
import io.apigee.trireme.kernel.util.BufferUtils;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLSConnection {
    private static final Logger log = LoggerFactory.getLogger((String)TLSConnection.class.getName());
    private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
    private final ArrayDeque<TLSChunk> outgoing = new ArrayDeque();
    private final ArrayDeque<TLSChunk> incoming = new ArrayDeque();
    private final GenericNodeRuntime runtime;
    private final boolean isServer;
    private final String serverName;
    private final int serverPort;
    private boolean requestCert;
    private boolean rejectUnauthorized;
    private TriCallback<ByteBuffer, Boolean, Object> writeCallback;
    private BiCallback<ByteBuffer, Integer> readCallback;
    private Callback<Void> onHandshakeStart;
    private Callback<Void> onHandshakeDone;
    private Callback<SSLException> onError;
    private SSLEngine engine;
    private X509TrustManager trustManager;
    private ByteBuffer writeBuf;
    private ByteBuffer readBuf;
    private boolean handshaking;
    private boolean initFinished;
    private boolean sentShutdown;
    private boolean receivedShutdown;
    private SSLException error;
    private SSLException verifyError;

    public TLSConnection(GenericNodeRuntime runtime, boolean serverMode, String serverName, int port) {
        this.runtime = runtime;
        this.isServer = serverMode;
        this.serverName = serverName;
        this.serverPort = port;
    }

    public void init(SSLContext ctx, String[] ciphers, X509TrustManager trustManager) {
        this.trustManager = trustManager;
        this.engine = !this.isServer && this.serverName != null ? ctx.createSSLEngine(this.serverName, this.serverPort) : ctx.createSSLEngine();
        this.engine.setUseClientMode(!this.isServer);
        if (log.isDebugEnabled()) {
            log.debug("Created SSLEngine {}", (Object)this.engine);
        }
        if (log.isDebugEnabled()) {
            log.debug("Allocating read and write buffers of size {}", (Object)this.engine.getSession().getPacketBufferSize());
        }
        this.readBuf = ByteBuffer.allocate(this.engine.getSession().getPacketBufferSize());
        this.writeBuf = ByteBuffer.allocate(this.engine.getSession().getPacketBufferSize());
        if (ciphers != null) {
            try {
                this.engine.setEnabledCipherSuites(ciphers);
            }
            catch (IllegalArgumentException iae) {
                this.handleError(new SSLException(iae));
            }
        }
    }

    public void setVerificationMode(boolean requestCert, boolean rejectUnauthorized) {
        this.requestCert = requestCert;
        this.rejectUnauthorized = rejectUnauthorized;
        if (requestCert) {
            if (rejectUnauthorized) {
                this.engine.setNeedClientAuth(true);
            } else {
                this.engine.setWantClientAuth(true);
            }
        }
    }

    public void setWriteCallback(TriCallback<ByteBuffer, Boolean, Object> cb) {
        this.writeCallback = cb;
    }

    public void setReadCallback(BiCallback<ByteBuffer, Integer> cb) {
        this.readCallback = cb;
    }

    public void setHandshakeStartCallback(Callback<Void> cb) {
        this.onHandshakeStart = cb;
    }

    public void setHandshakeDoneCallback(Callback<Void> cb) {
        this.onHandshakeDone = cb;
    }

    public void setErrorCallback(Callback<SSLException> cb) {
        this.onError = cb;
    }

    public SSLException getVerifyError() {
        return this.verifyError;
    }

    public SSLException getError() {
        return this.error;
    }

    public boolean isInitFinished() {
        return this.initFinished;
    }

    public boolean isSentShutdown() {
        return this.sentShutdown;
    }

    public boolean isReceivedShutdown() {
        return this.receivedShutdown;
    }

    public int getWriteQueueLength() {
        int len = 0;
        for (TLSChunk c : this.outgoing) {
            if (c.getBuf() == null) continue;
            len += c.getBuf().remaining();
        }
        return len;
    }

    public void wrap(ByteBuffer buf, Callback<Object> cb) {
        this.outgoing.add(new TLSChunk(buf, false, cb));
        this.encodeLoop();
    }

    public void shutdown(Callback<Object> cb) {
        this.outgoing.add(new TLSChunk(null, true, cb));
        this.encodeLoop();
    }

    public void shutdownInbound(Callback<Object> cb) {
        block3: {
            try {
                this.engine.closeInbound();
            }
            catch (SSLException ssle) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Error closing inbound SSLEngine: {}", (Throwable)ssle);
            }
        }
        if (cb != null) {
            cb.call(null);
        }
        this.doUnwrap();
        this.encodeLoop();
    }

    public void unwrap(ByteBuffer buf, Callback<Object> cb) {
        this.incoming.add(new TLSChunk(buf, false, cb));
        this.encodeLoop();
    }

    public void inboundError(int err) {
        TLSChunk c = new TLSChunk(null, false, null);
        c.setInboundErr(err);
        this.incoming.add(c);
        this.encodeLoop();
    }

    public void start() {
        if (!this.isServer) {
            this.wrap(null, null);
        }
    }

    private void encodeLoop() {
        block6: while (true) {
            if (log.isTraceEnabled()) {
                log.trace("engine status: {} incoming: {} outgoing: {}", new Object[]{this.engine.getHandshakeStatus(), this.incoming.size(), this.outgoing.size()});
            }
            switch (this.engine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    this.processHandshaking();
                    if (this.doWrap()) break;
                    return;
                }
                case NEED_UNWRAP: {
                    this.processHandshaking();
                    if (this.doUnwrap()) break;
                    return;
                }
                case NEED_TASK: {
                    this.processTasks();
                    return;
                }
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    if (this.outgoing.isEmpty() && this.incoming.isEmpty()) {
                        return;
                    }
                    if (!this.outgoing.isEmpty() && !this.doWrap()) {
                        return;
                    }
                    if (this.incoming.isEmpty() || this.doUnwrap()) continue block6;
                    return;
                }
            }
        }
    }

    private boolean doWrap() {
        SSLEngineResult result;
        ByteBuffer bb;
        TLSChunk qc = this.outgoing.peek();
        ByteBuffer byteBuffer = bb = qc == null ? EMPTY : qc.getBuf();
        if (bb == null) {
            bb = EMPTY;
        }
        boolean wasShutdown = false;
        do {
            if (qc != null && qc.isShutdown()) {
                log.trace("Sending closeOutbound");
                this.engine.closeOutbound();
                this.sentShutdown = true;
                wasShutdown = true;
            }
            if (log.isTraceEnabled()) {
                log.trace("Wrapping {}", (Object)bb);
            }
            try {
                result = this.engine.wrap(bb, this.writeBuf);
            }
            catch (SSLException ssle) {
                this.handleEncodingError(qc, ssle);
                if (qc != null) {
                    this.outgoing.remove();
                }
                return false;
            }
            if (log.isTraceEnabled()) {
                log.trace("wrap result: {}", (Object)result);
            }
            if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            this.writeBuf = BufferUtils.doubleBuffer(this.writeBuf);
        } while (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW);
        Callback<Object> cb = null;
        if (qc != null && !bb.hasRemaining() && this.initFinished) {
            this.outgoing.remove();
            cb = qc.removeCallback();
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.processNotHandshaking();
        }
        if (result.bytesProduced() > 0) {
            this.deliverWriteBuffer(wasShutdown, cb);
        } else if (cb != null) {
            cb.call(null);
        }
        return result.getStatus() == SSLEngineResult.Status.OK;
    }

    private boolean doUnwrap() {
        int err;
        TLSChunk qc = this.incoming.peek();
        ByteBuffer bb = qc == null ? EMPTY : qc.getBuf();
        SSLEngineResult result = null;
        while (bb != null) {
            do {
                if (log.isTraceEnabled()) {
                    log.trace("Unwrapping {}", (Object)bb);
                }
                try {
                    result = this.engine.unwrap(bb, this.readBuf);
                }
                catch (SSLException ssle) {
                    this.handleEncodingError(qc, ssle);
                    return false;
                }
                if (log.isTraceEnabled()) {
                    log.trace("unwrap result: {}", (Object)result);
                }
                if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                this.readBuf = BufferUtils.doubleBuffer(this.readBuf);
            } while (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW);
            if (result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW || qc == null) break;
            Callback<Object> cb = qc.removeCallback();
            if (cb != null) {
                cb.call(null);
            }
            if (this.incoming.size() >= 2) {
                TLSChunk c1 = this.incoming.poll();
                qc = this.incoming.peek();
                qc.setBuf(BufferUtils.catBuffers(c1.getBuf(), qc.getBuf()));
                bb = qc.getBuf();
                continue;
            }
            qc = this.incoming.peek();
            break;
        }
        int n = err = qc == null ? 0 : qc.getInboundErr();
        if (err != 0) {
            try {
                this.engine.closeInbound();
            }
            catch (SSLException c1) {
                // empty catch block
            }
        }
        if (result != null && result.getStatus() == SSLEngineResult.Status.CLOSED && !this.receivedShutdown) {
            this.receivedShutdown = true;
            err = -99;
        }
        if (!(qc == null || qc.getBuf() != null && qc.getBuf().hasRemaining())) {
            this.incoming.poll();
            Callback<Object> cb = qc.removeCallback();
            if (cb != null) {
                cb.call(null);
            }
        }
        if (result != null && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.processNotHandshaking();
        }
        if (result != null && result.bytesProduced() > 0 || err != 0) {
            this.deliverReadBuffer(err);
        }
        return result == null || result.getStatus() == SSLEngineResult.Status.OK;
    }

    private void deliverWriteBuffer(boolean shutdown, Callback<Object> cb) {
        if (this.writeCallback != null) {
            ByteBuffer bb;
            if (this.writeBuf.position() > 0) {
                this.writeBuf.flip();
                bb = ByteBuffer.allocate(this.writeBuf.remaining());
                bb.put(this.writeBuf);
                this.writeBuf.clear();
                bb.flip();
                if (log.isTraceEnabled()) {
                    log.trace("Delivering {} bytes to the onwrap callback. shutdown = {}", (Object)bb.remaining(), (Object)shutdown);
                }
            } else {
                bb = null;
            }
            this.writeCallback.call(bb, shutdown, cb);
        } else {
            this.writeBuf.clear();
            if (cb != null) {
                cb.call(null);
            }
        }
    }

    private void deliverReadBuffer(int err) {
        if (this.readCallback != null) {
            ByteBuffer bb;
            if (this.readBuf.position() > 0) {
                this.readBuf.flip();
                bb = ByteBuffer.allocate(this.readBuf.remaining());
                bb.put(this.readBuf);
                bb.flip();
                this.readBuf.clear();
                if (log.isTraceEnabled()) {
                    log.trace("Delivering {} bytes to the onunwrap callback. err = {}", (Object)bb.remaining(), (Object)err);
                }
            } else {
                bb = null;
            }
            this.readCallback.call(bb, err);
        } else {
            this.readBuf.clear();
        }
    }

    private void processHandshaking() {
        if (!(this.handshaking || this.sentShutdown || this.receivedShutdown)) {
            this.handshaking = true;
            if (this.onHandshakeStart != null) {
                this.onHandshakeStart.call(null);
            }
        }
    }

    private void processNotHandshaking() {
        if (this.handshaking) {
            this.checkPeerAuthorization();
            this.handshaking = false;
            this.initFinished = true;
            if (this.onHandshakeDone != null) {
                this.onHandshakeDone.call(null);
            }
        }
    }

    private void processTasks() {
        this.runtime.getAsyncPool().submit(new Runnable(){

            public void run() {
                Runnable task = TLSConnection.this.engine.getDelegatedTask();
                while (task != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("Running SSLEngine task {}", (Object)task);
                    }
                    task.run();
                    task = TLSConnection.this.engine.getDelegatedTask();
                }
                Object domain = TLSConnection.this.runtime.getDomain();
                TLSConnection.this.runtime.executeScriptTask(new Runnable(){

                    public void run() {
                        TLSConnection.this.encodeLoop();
                    }
                }, domain);
            }
        });
    }

    private void handleError(SSLException ssle) {
        if (log.isDebugEnabled()) {
            log.debug("SSL exception: handshaking = {}: {}", new Object[]{this.handshaking, ssle, ssle});
        }
        Throwable cause = ssle;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (this.handshaking) {
            this.verifyError = ssle;
        } else {
            this.error = ssle;
        }
    }

    private void handleEncodingError(TLSChunk qc, SSLException ssle) {
        if (log.isDebugEnabled()) {
            log.debug("SSL exception: {}", (Object)ssle, (Object)ssle);
        }
        Throwable cause = ssle;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        this.error = ssle;
        if (!this.initFinished) {
            this.verifyError = ssle;
            if (this.onError != null) {
                this.onError.call(ssle);
            }
        } else if (qc != null) {
            Callback<Object> cb = qc.removeCallback();
            if (cb != null) {
                cb.call(ssle.toString());
            }
        } else if (this.onError != null) {
            this.onError.call(ssle);
        }
    }

    private void checkPeerAuthorization() {
        Certificate[] certChain;
        try {
            certChain = this.engine.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException unver) {
            if (log.isDebugEnabled()) {
                log.debug("Peer is unverified");
            }
            if (!this.isServer || this.requestCert) {
                this.handleError(unver);
            }
            return;
        }
        if (certChain == null) {
            if (log.isDebugEnabled()) {
                log.debug("Peer has no client- or server-side certs");
            }
            if (!this.isServer || this.requestCert) {
                this.handleError(new SSLException("Peer has no certificates"));
            }
            return;
        }
        if (this.trustManager == null) {
            this.handleError(new SSLException("No trusted CAs"));
            return;
        }
        try {
            String algo = this.figureTrustAlgorithm();
            if (this.isServer) {
                this.trustManager.checkClientTrusted((X509Certificate[])certChain, algo);
            } else {
                this.trustManager.checkServerTrusted((X509Certificate[])certChain, algo);
            }
            if (log.isDebugEnabled()) {
                log.debug("SSL peer {} is valid", (Object)this.engine.getSession());
            }
        }
        catch (CertificateException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error verifying SSL peer {}: {}", (Object)this.engine.getSession(), (Object)e);
            }
            this.handleError(new SSLException(e));
        }
    }

    private String figureTrustAlgorithm() {
        String suite = this.engine.getSession().getCipherSuite();
        String protocol = this.engine.getSession().getProtocol();
        String algo = suite.startsWith("TLS_ECDHE_ECDSA") ? "ECDHE_ECDSA" : (suite.startsWith("TLS_ECDHE_RSA") ? "ECDHE_RSA" : (suite.startsWith("TLS_ECDH_ECDSA") ? "ECDH_ECDSA" : (suite.startsWith("TLS_DHE_DSS") ? "DHE_DSS" : (suite.startsWith("TLS_DHE_RSA") ? "DHE_RSA" : (suite.startsWith("TLS_ECDH_RSA") ? "ECDH_RSA" : (suite.startsWith("SSL_RSA_EXPORT") ? "RSA_EXPORT" : (suite.startsWith("TLS_RSA") || suite.startsWith("SSL_RSA") ? "RSA" : "UNKNOWN")))))));
        if (log.isDebugEnabled()) {
            log.debug("Protocol = {}: suite = {}. Checking trust using {}", new Object[]{protocol, suite, algo});
        }
        return algo;
    }

    public X509Certificate getPeerCertificate() {
        Certificate cert;
        if (this.engine.getSession() == null) {
            return null;
        }
        try {
            cert = this.engine.getSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException puve) {
            if (log.isDebugEnabled()) {
                log.debug("getPeerCertificates threw {}", (Throwable)puve);
            }
            cert = null;
        }
        if (!(cert instanceof X509Certificate)) {
            log.debug("Peer certificate is not an X.509 cert");
            return null;
        }
        return (X509Certificate)cert;
    }

    public String getCipherSuite() {
        if (this.engine.getSession() == null) {
            return null;
        }
        return this.engine.getSession().getCipherSuite();
    }

    public String getProtocol() {
        if (this.engine.getSession() == null) {
            return null;
        }
        return this.engine.getSession().getProtocol();
    }
}

