/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.handles;

import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.handles.AbstractNIOHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.net.NetworkPolicy;
import io.apigee.trireme.kernel.net.SelectorHandler;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIODatagramHandle
extends AbstractNIOHandle {
    private static final Logger log = LoggerFactory.getLogger(NIODatagramHandle.class);
    public static final int MAX_READ_BUFFER = 8192;
    private DatagramChannel channel;
    private boolean readStarted;
    private IOCompletionHandler<ReceivedDatagram> readHandler;
    private ByteBuffer receiveBuffer;

    public NIODatagramHandle(GenericNodeRuntime runtime) {
        super(runtime);
    }

    public void bind(String address, int port) throws OSException {
        InetSocketAddress bound;
        if (address == null && port == 0) {
            bound = null;
        } else {
            bound = new InetSocketAddress(address, port);
            if (bound.isUnresolved()) {
                throw new OSException(-2);
            }
        }
        boolean success = false;
        try {
            this.channel = DatagramChannel.open();
            this.runtime.registerCloseable(this.channel);
            this.channel.configureBlocking(false);
            this.channel.socket().bind(bound);
            this.selKey = this.channel.register(this.runtime.getSelector(), 0, new SelectorHandler(){

                public void selected(SelectionKey key) {
                    NIODatagramHandle.this.clientSelected(key);
                }
            });
            success = true;
        }
        catch (BindException be) {
            log.debug("Error binding: {}", (Throwable)be);
            throw new OSException(-48);
        }
        catch (IOException ioe) {
            log.debug("Error binding: {}", (Throwable)ioe);
            throw new OSException(-5);
        }
        finally {
            if (!success) {
                this.runtime.unregisterCloseable(this.channel);
                try {
                    this.channel.close();
                }
                catch (IOException ioe) {
                    log.debug("Error closing channel that might be closed: {}", (Throwable)ioe);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.runtime.unregisterCloseable(this.channel);
            try {
                this.channel.close();
            }
            catch (IOException ioe) {
                log.debug("Uncaught exception in channel close: {}", (Throwable)ioe);
            }
        }
    }

    public int send(String host, int port, ByteBuffer buf, IOCompletionHandler<Integer> handler) throws OSException {
        InetSocketAddress addr = new InetSocketAddress(host, port);
        NetworkPolicy netPolicy = this.getNetworkPolicy();
        if (netPolicy != null && !netPolicy.allowListening(addr)) {
            log.debug("Address {} not allowed by network policy", (Object)addr);
            throw new OSException(-22);
        }
        AbstractNIOHandle.QueuedWrite qw = new AbstractNIOHandle.QueuedWrite(buf, handler);
        qw.setAddress(addr);
        this.offerWrite(qw);
        return qw.length;
    }

    private void offerWrite(AbstractNIOHandle.QueuedWrite qw) {
        if (this.writeQueue.isEmpty() && !qw.shutdown) {
            int written;
            try {
                written = this.channel.send(qw.buf, qw.address);
            }
            catch (IOException ioe) {
                this.queueWrite(qw);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Wrote {} to {} from {}", new Object[]{written, this.channel, qw.buf});
            }
            if (qw.buf.hasRemaining()) {
                this.writeReady = false;
                this.queueWrite(qw);
            } else {
                qw.getHandler().ioComplete(0, qw.getLength());
            }
        } else {
            this.queueWrite(qw);
        }
    }

    @Override
    protected void processWrites() {
        AbstractNIOHandle.QueuedWrite qw;
        this.writeReady = true;
        this.removeInterest(4);
        while ((qw = (AbstractNIOHandle.QueuedWrite)this.writeQueue.pollFirst()) != null) {
            this.queuedBytes -= qw.getLength();
            assert (this.queuedBytes >= 0);
            try {
                int written = this.channel.send(qw.buf, qw.address);
                if (log.isDebugEnabled()) {
                    log.debug("Wrote {} to {} from {}", new Object[]{written, this.channel, qw.buf});
                }
                if (qw.buf.hasRemaining()) {
                    this.writeReady = false;
                    this.writeQueue.addFirst(qw);
                    this.queuedBytes += qw.getLength();
                    this.addInterest(4);
                    break;
                }
                qw.getHandler().ioComplete(0, qw.getLength());
            }
            catch (ClosedChannelException cce) {
                if (log.isDebugEnabled()) {
                    log.debug("Channel is closed");
                }
                qw.getHandler().ioComplete(-99, 0);
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("Error on write: {}", (Throwable)ioe);
                }
                qw.getHandler().ioComplete(-5, 0);
            }
        }
    }

    public void startReadingDatagrams(IOCompletionHandler<ReceivedDatagram> handler) {
        if (!this.readStarted) {
            this.readHandler = handler;
            if (this.receiveBuffer == null) {
                try {
                    this.receiveBuffer = ByteBuffer.allocate(Math.min(8192, this.channel.socket().getReceiveBufferSize()));
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
            this.addInterest(1);
            this.readStarted = true;
        }
    }

    @Override
    public void stopReading() {
        if (this.readStarted) {
            this.removeInterest(1);
            this.readStarted = false;
        }
    }

    @Override
    protected void processReads() {
        SocketAddress addr;
        if (!this.readStarted) {
            return;
        }
        do {
            Object buf = null;
            try {
                this.receiveBuffer.clear();
                addr = this.channel.receive(this.receiveBuffer);
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("Error reading from channel: {}", (Object)ioe, (Object)ioe);
                }
                addr = null;
            }
            if (log.isDebugEnabled()) {
                log.debug("Read from {} into {}", (Object)this.channel, buf);
            }
            if (addr == null) continue;
            this.receiveBuffer.flip();
            ByteBuffer readBuf = ByteBuffer.allocate(this.receiveBuffer.remaining());
            readBuf.put(this.receiveBuffer);
            readBuf.flip();
            this.readHandler.ioComplete(0, new ReceivedDatagram(readBuf, addr));
        } while (this.readStarted && addr != null);
    }

    @Override
    protected void processConnect() {
        throw new AssertionError();
    }

    public InetSocketAddress getSockName() {
        return (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
    }

    public void setBroadcast(boolean on) throws OSException {
        try {
            this.channel.socket().setBroadcast(true);
        }
        catch (IOException e) {
            throw new OSException(-5, (Throwable)e);
        }
    }

    public void setMulticastTtl(int ttl) throws OSException {
        try {
            this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)ttl);
        }
        catch (IOException e) {
            throw new OSException(-5, (Throwable)e);
        }
        catch (NoClassDefFoundError cnfe) {
            throw new OSException(-3, "Multicast not available on Java 6");
        }
    }

    public void setMulticastLoopback(boolean on) throws OSException {
        try {
            this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)on);
        }
        catch (IOException e) {
            throw new OSException(-5, (Throwable)e);
        }
        catch (NoClassDefFoundError cnfe) {
            throw new OSException(-3, "Multicast not available on Java 6");
        }
    }

    public static class ReceivedDatagram {
        private final ByteBuffer buf;
        private final SocketAddress address;

        ReceivedDatagram(ByteBuffer buf, SocketAddress addr) {
            this.buf = buf;
            this.address = addr;
        }

        public ByteBuffer getBuffer() {
            return this.buf;
        }

        public SocketAddress getAddress() {
            return this.address;
        }
    }
}

