/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.handles;

import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.util.PinState;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaInputStreamHandle
extends AbstractHandle {
    private static final int READ_BUFFER_SIZE = 16392;
    private final InputStream in;
    private final GenericNodeRuntime runtime;
    private final PinState pinState = new PinState();
    private Future<?> readTask;
    private volatile boolean reading;

    public JavaInputStreamHandle(InputStream in, GenericNodeRuntime runtime) {
        this.in = in;
        this.runtime = runtime;
    }

    @Override
    public void startReading(final IOCompletionHandler<ByteBuffer> handler) {
        if (this.reading) {
            return;
        }
        this.reading = true;
        this.pinState.requestPin(this.runtime);
        this.readTask = this.runtime.getUnboundedPool().submit(new Runnable(){

            public void run() {
                JavaInputStreamHandle.this.readLoop(handler);
            }
        });
    }

    protected void readLoop(IOCompletionHandler<ByteBuffer> handler) {
        byte[] readBuf = new byte[16392];
        try {
            int count = 0;
            while (this.reading && count >= 0) {
                count = this.in.read(readBuf);
                if (count <= 0) continue;
                ByteBuffer buf = ByteBuffer.allocate(count);
                buf.put(readBuf, 0, count);
                buf.flip();
                this.deliverResult(0, buf, handler);
            }
            if (count < 0) {
                this.deliverResult(-99, null, handler);
            }
        }
        catch (InterruptedIOException count) {
        }
        catch (EOFException eofe) {
            this.deliverResult(-99, null, handler);
        }
        catch (IOException ioe) {
            int err = "Stream Closed".equalsIgnoreCase(ioe.getMessage()) ? -99 : -5;
            this.deliverResult(err, null, handler);
        }
    }

    private void deliverResult(final int err, final ByteBuffer val, final IOCompletionHandler<ByteBuffer> handler) {
        this.runtime.executeScriptTask(new Runnable(){

            public void run() {
                handler.ioComplete(err, val);
            }
        }, null);
    }

    @Override
    public void stopReading() {
        if (this.reading) {
            this.pinState.clearPin(this.runtime);
            this.reading = false;
        }
        if (this.readTask != null) {
            this.readTask.cancel(true);
        }
    }

    @Override
    public void close() {
        this.stopReading();
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

