/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.handles;

import io.apigee.trireme.kernel.Charsets;
import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.TriCallback;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.util.StringUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpcHandle
extends AbstractHandle {
    private static final Logger log = LoggerFactory.getLogger(IpcHandle.class);
    private final ConcurrentLinkedQueue<QueuedWrite> writeQueue = new ConcurrentLinkedQueue();
    private final GenericNodeRuntime runtime;
    private IpcHandle partner;
    private IOCompletionHandler<ByteBuffer> handler;
    private volatile boolean reading;
    private TriCallback<Integer, ByteBuffer, Object> ipcCallback;

    public IpcHandle(GenericNodeRuntime runtime) {
        this.runtime = runtime;
    }

    public TriCallback<Integer, ByteBuffer, Object> getIpcCallback() {
        return this.ipcCallback;
    }

    public void setIpcCallback(TriCallback<Integer, ByteBuffer, Object> cb) {
        this.ipcCallback = cb;
    }

    @Override
    public int write(ByteBuffer buf, IOCompletionHandler<Integer> handler) {
        return this.doWrite(buf, null, handler);
    }

    @Override
    public int write(String s, Charset cs, IOCompletionHandler<Integer> handler) {
        return this.writeHandle(s, cs, null, handler);
    }

    @Override
    public int writeHandle(String s, Charset cs, Object handleArg, IOCompletionHandler<Integer> handler) {
        return this.doWrite(StringUtils.stringToBuffer(s, cs), handleArg, handler);
    }

    @Override
    public int writeHandle(ByteBuffer buf, Object handleArg, IOCompletionHandler<Integer> handler) {
        ByteBuffer copy = ByteBuffer.allocate(buf.remaining());
        copy.put(buf);
        return this.doWrite(buf, handleArg, handler);
    }

    private int doWrite(ByteBuffer buf, Object handleArg, IOCompletionHandler<Integer> handler) {
        if (log.isDebugEnabled()) {
            log.debug("IpcHandle.write: " + StringUtils.bufferToString(buf.duplicate(), Charsets.UTF8));
        }
        int len = buf.remaining();
        QueuedWrite qw = new QueuedWrite();
        qw.buf = buf;
        qw.handler = handler;
        qw.handleArg = handleArg;
        qw.handlerRuntime = this.runtime;
        this.writeQueue.offer(qw);
        if (log.isDebugEnabled()) {
            log.debug("Queued {} bytes on the write queue", (Object)len);
        }
        if (this.partner != null && this.partner.reading) {
            if (log.isDebugEnabled()) {
                log.debug("Delivering {} bytes directly to partner handle", (Object)len);
            }
            this.partner.drainWriteQueue(this.partner.runtime);
        }
        return len;
    }

    @Override
    public int getWritesOutstanding() {
        int len = 0;
        for (QueuedWrite qw : this.writeQueue) {
            ByteBuffer buf = qw.buf;
            len += buf == null ? 0 : buf.remaining();
        }
        return len;
    }

    @Override
    public void startReading(IOCompletionHandler<ByteBuffer> handler) {
        log.debug("IpcHandle.startReading");
        this.reading = true;
        this.handler = handler;
        this.drainWriteQueue(this.runtime);
    }

    private void drainWriteQueue(GenericNodeRuntime runner) {
        runner.executeScriptTask(new Runnable(){

            public void run() {
                IpcHandle.this.doDrain();
            }
        }, null);
    }

    private void doDrain() {
        if (this.partner != null) {
            QueuedWrite qw;
            if (log.isDebugEnabled()) {
                log.debug("Draining write queue. size = {}", (Object)this.partner.writeQueue.size());
            }
            do {
                if ((qw = this.partner.writeQueue.poll()) == null) continue;
                this.deliverWrite(qw);
            } while (this.reading && qw != null);
        }
    }

    @Override
    public void stopReading() {
        this.reading = false;
    }

    public void connect(IpcHandle partner) {
        log.debug("IpcHandle.connect");
        this.partner = partner;
        partner.partner = this;
        if (this.reading) {
            this.drainWriteQueue(this.runtime);
        }
        if (partner.reading) {
            partner.drainWriteQueue(partner.runtime);
        }
    }

    @Override
    public void close() {
        this.stopReading();
        if (this.partner != null) {
            log.debug("Sending EOF to our partner");
            QueuedWrite qw = new QueuedWrite();
            qw.eof = true;
            this.writeQueue.offer(qw);
            if (this.partner.reading) {
                this.partner.drainWriteQueue(this.partner.runtime);
            }
        }
        this.partner = null;
    }

    private void deliverWrite(final QueuedWrite qw) {
        if (this.handler != null || this.ipcCallback != null) {
            int err;
            if (log.isDebugEnabled()) {
                log.debug("Delivering {} to the local script from the other side", (Object)qw.buf);
            }
            final int len = qw.buf == null ? 0 : qw.buf.remaining();
            int n = err = qw.eof ? -99 : 0;
            if (this.ipcCallback == null) {
                this.handler.ioComplete(err, qw.buf);
            } else {
                this.ipcCallback.call(err, qw.buf, qw.handleArg);
            }
            if (qw.handler != null) {
                qw.handlerRuntime.executeScriptTask(new Runnable(){

                    public void run() {
                        qw.handler.ioComplete(err, len);
                    }
                }, null);
            }
        }
    }

    private static class QueuedWrite {
        ByteBuffer buf;
        IOCompletionHandler<Integer> handler;
        Object handleArg;
        boolean eof;
        GenericNodeRuntime handlerRuntime;

        private QueuedWrite() {
        }
    }
}

