/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.handles;

import io.apigee.trireme.kernel.Charsets;
import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.util.StringUtils;
import java.io.Console;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleHandle
extends AbstractHandle {
    private static final int READ_BUFFER_SIZE = 8192;
    private final Console console = System.console();
    private final PrintWriter writer = this.console.writer();
    private final Reader reader = this.console.reader();
    private final GenericNodeRuntime runtime;
    private volatile boolean reading;
    private Future<?> readTask;

    public static boolean isConsoleSupported() {
        return System.console() != null;
    }

    public ConsoleHandle(GenericNodeRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public int write(ByteBuffer buf, IOCompletionHandler<Integer> handler) {
        int len = buf.remaining();
        String str = StringUtils.bufferToString(buf, Charsets.UTF8);
        this.writer.print(str);
        this.writer.flush();
        handler.ioComplete(0, len);
        return len;
    }

    @Override
    public int write(String s, Charset cs, IOCompletionHandler<Integer> handler) {
        int len = s.length();
        this.writer.print(s);
        this.writer.flush();
        handler.ioComplete(0, len);
        return len;
    }

    @Override
    public void startReading(final IOCompletionHandler<ByteBuffer> handler) {
        if (this.reading) {
            return;
        }
        this.reading = true;
        this.runtime.pin();
        this.readTask = this.runtime.getUnboundedPool().submit(new Runnable(){

            public void run() {
                ConsoleHandle.this.readLoop(handler);
            }
        });
    }

    protected void readLoop(IOCompletionHandler<ByteBuffer> handler) {
        char[] readBuf = new char[8192];
        try {
            int count = 0;
            while (this.reading && count >= 0) {
                count = this.reader.read(readBuf);
                if (count <= 0) continue;
                String rs = new String(readBuf, 0, count);
                ByteBuffer buf = StringUtils.stringToBuffer(rs, Charsets.UTF8);
                this.deliverResult(0, buf, handler);
            }
            if (count < 0) {
                this.deliverResult(-99, null, handler);
            }
        }
        catch (InterruptedIOException count) {
        }
        catch (EOFException eofe) {
            this.deliverResult(-99, null, handler);
        }
        catch (IOException ioe) {
            int err = "Stream Closed".equalsIgnoreCase(ioe.getMessage()) ? -99 : -5;
            this.deliverResult(err, null, handler);
        }
    }

    @Override
    public void stopReading() {
        if (this.reading) {
            this.runtime.unPin();
            this.reading = false;
        }
        if (this.readTask != null) {
            this.readTask.cancel(true);
        }
    }

    private void deliverResult(final int err, final ByteBuffer val, final IOCompletionHandler<ByteBuffer> handler) {
        this.runtime.executeScriptTask(new Runnable(){

            public void run() {
                handler.ioComplete(err, val);
            }
        }, null);
    }

    @Override
    public void close() {
    }
}

