/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.handles;

import io.apigee.trireme.kernel.handles.Handle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.util.StringUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandle
implements Handle {
    private boolean deliveredEof;

    @Override
    public int write(ByteBuffer buf, IOCompletionHandler<Integer> handler) {
        throw new IllegalStateException("Handle not capable of writing");
    }

    @Override
    public int writeHandle(ByteBuffer buf, Object handleArg, IOCompletionHandler<Integer> handler) {
        throw new IllegalStateException("Handle does not support passing handles");
    }

    @Override
    public int write(String s, Charset cs, IOCompletionHandler<Integer> handler) {
        ByteBuffer buf = StringUtils.stringToBuffer(s, cs);
        return this.write(buf, handler);
    }

    @Override
    public int writeHandle(String s, Charset cs, Object handleArg, IOCompletionHandler<Integer> handler) {
        ByteBuffer buf = StringUtils.stringToBuffer(s, cs);
        return this.writeHandle(buf, handleArg, handler);
    }

    @Override
    public int getWritesOutstanding() {
        return 0;
    }

    @Override
    public void startReading(IOCompletionHandler<ByteBuffer> handler) {
        if (!this.deliveredEof) {
            this.deliveredEof = true;
            handler.ioComplete(-99, null);
        }
    }

    @Override
    public void stopReading() {
    }

    @Override
    public abstract void close();

    @Override
    public IOCompletionHandler<ByteBuffer> getReadHandler() {
        return null;
    }

    @Override
    public void setReadHandler(IOCompletionHandler<ByteBuffer> h) {
    }
}

