/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.fs;

import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.Platform;
import io.apigee.trireme.kernel.fs.AbstractFileHandle;
import io.apigee.trireme.kernel.fs.BasicFilesystem;
import io.apigee.trireme.kernel.fs.FileStats;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedFilesystem
extends BasicFilesystem {
    private static final Logger log = LoggerFactory.getLogger(AdvancedFilesystem.class);
    public static final Pattern NOT_DIRECTORY_MSG = Pattern.compile(".*[Nn]ot a directory$");

    @Override
    public int open(File fp, String origPath, int flags, int mode, int umask) throws OSException {
        if (log.isDebugEnabled()) {
            log.debug("open({}, {}, {})", new Object[]{origPath, flags, mode});
        }
        FileChannel file = null;
        Path path = Paths.get(fp.getPath(), new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
            if ((flags & 0x200) != 0) {
                if ((flags & 0x800) != 0) {
                    options.add(StandardOpenOption.CREATE_NEW);
                } else {
                    options.add(StandardOpenOption.CREATE);
                }
            }
            if ((flags & 2) != 0) {
                options.add(StandardOpenOption.READ);
                options.add(StandardOpenOption.WRITE);
            } else if ((flags & 1) != 0) {
                options.add(StandardOpenOption.WRITE);
            } else {
                options.add(StandardOpenOption.READ);
            }
            if ((flags & 0x400) != 0) {
                options.add(StandardOpenOption.TRUNCATE_EXISTING);
            }
            if ((flags & 0x80) != 0) {
                options.add(StandardOpenOption.SYNC);
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Opening {} with {}", (Object)path, options);
                }
                if (Platform.get().isPosixFilesystem()) {
                    file = FileChannel.open(path, options, PosixFilePermissions.asFileAttribute(this.modeToPerms(mode, umask, true)));
                } else {
                    file = FileChannel.open(path, options, new FileAttribute[0]);
                    this.setModeNoPosix(fp, mode, umask);
                }
            }
            catch (IOException ioe) {
                throw new OSException(this.getErrorCode(ioe), ioe, origPath);
            }
        }
        try {
            AbstractFileHandle fileHandle = new AbstractFileHandle(fp, origPath, file);
            int fd = this.nextFd.getAndIncrement();
            fileHandle.setFd(fd);
            if (log.isDebugEnabled()) {
                log.debug("  open({}) = {}", (Object)origPath, (Object)fd);
            }
            if ((flags & 8) != 0 && file != null && file.size() > 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("  setting file position to {}", (Object)file.size());
                }
                fileHandle.setPosition(file.size());
            }
            this.descriptors.put(fd, fileHandle);
            return fd;
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), ioe, origPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ftruncate(int fd, long len) throws OSException {
        AbstractFileHandle handle = this.ensureRegularFileHandle(fd);
        try {
            RandomAccessFile tmp = new RandomAccessFile(handle.getFile(), "rw");
            try {
                tmp.setLength(len);
            }
            finally {
                tmp.close();
            }
        }
        catch (IOException e) {
            throw new OSException(-5, e, handle.getOrigPath());
        }
    }

    @Override
    public void rename(File oldFile, String oldPath, File newFile, String newPath) throws OSException {
        Path op = Paths.get(oldFile.getPath(), new String[0]);
        Path np = Paths.get(newFile.getPath(), new String[0]);
        try {
            try {
                Files.move(op, np, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException ae) {
                Files.move(op, np, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), newPath);
        }
    }

    @Override
    public void unlink(File file, String origPath) throws OSException {
        Path path = Paths.get(file.getPath(), new String[0]);
        try {
            Files.delete(path);
        }
        catch (DirectoryNotEmptyException dne) {
            throw new OSException(-1, dne, origPath);
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), ioe, origPath);
        }
    }

    @Override
    public void rmdir(File file, String origPath) throws OSException {
        Path p = Paths.get(file.getPath(), new String[0]);
        if (!Files.isDirectory(p, new LinkOption[0])) {
            throw new OSException(-20, origPath);
        }
        try {
            Files.delete(p);
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), ioe, origPath);
        }
    }

    @Override
    public List<String> readdir(File f, String origPath) throws OSException {
        if (!f.isDirectory()) {
            throw new OSException(-20, origPath);
        }
        Path path = Paths.get(f.getPath(), new String[0]);
        final ArrayList<String> paths = new ArrayList<String>();
        Set<FileVisitOption> options = Collections.singleton(FileVisitOption.FOLLOW_LINKS);
        try {
            Files.walkFileTree(path, options, 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path child, BasicFileAttributes attrs) {
                    paths.add(child.getFileName().toString());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), origPath);
        }
        return paths;
    }

    @Override
    public void mkdir(File file, String origPath, int mode, int umask) throws OSException {
        if (log.isDebugEnabled()) {
            log.debug("mkdir({})", (Object)origPath);
        }
        Path p = Paths.get(file.getPath(), new String[0]);
        try {
            if (Platform.get().isPosixFilesystem()) {
                Set<PosixFilePermission> perms = this.modeToPerms(mode, umask, true);
                Files.createDirectory(p, PosixFilePermissions.asFileAttribute(perms));
            } else {
                Files.createDirectory(p, new FileAttribute[0]);
                this.setModeNoPosix(file, mode, umask);
            }
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), ioe, origPath);
        }
    }

    private Map<String, Object> readAttrs(String attrNames, Path p, boolean noFollow) throws IOException {
        if (noFollow) {
            return Files.readAttributes(p, attrNames, LinkOption.NOFOLLOW_LINKS);
        }
        return Files.readAttributes(p, attrNames, new LinkOption[0]);
    }

    @Override
    public FileStats stat(File f, String origPath, boolean noFollow) throws OSException {
        Path p = Paths.get(f.getPath(), new String[0]);
        try {
            HashMap<String, Object> attrs;
            if (Platform.get().isPosixFilesystem()) {
                attrs = this.readAttrs("posix:*", p, noFollow);
            } else {
                attrs = new HashMap<String, Object>();
                attrs.putAll(this.readAttrs("*", p, noFollow));
                attrs.putAll(this.readAttrs("owner:*", p, noFollow));
            }
            return new FileStats(f, attrs);
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), ioe, origPath);
        }
        catch (Throwable t) {
            log.error("Error on stat: {}", t);
            throw new OSException(-5, t);
        }
    }

    @Override
    public void utimes(File f, String origPath, long atime, long mtime) throws OSException {
        try {
            boolean nofollow = false;
            Path path = Paths.get(f.getPath(), new String[0]);
            BasicFileAttributeView attrView = nofollow ? Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS) : Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
            BasicFileAttributes attrs = attrView.readAttributes();
            FileTime newATime = FileTime.fromMillis(atime);
            FileTime newMTime = FileTime.fromMillis(mtime);
            attrView.setTimes(newMTime, newATime, attrs.creationTime());
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), ioe, origPath);
        }
    }

    @Override
    public void chmod(File f, String origPath, int mode, int umask, boolean noFollow) throws OSException {
        Set<PosixFilePermission> perms = this.modeToPerms(mode, umask, false);
        Path path = Paths.get(f.getPath(), new String[0]);
        try {
            if (Platform.get().isPosixFilesystem()) {
                if (noFollow) {
                    Files.setAttribute(path, "posix:permissions", perms, LinkOption.NOFOLLOW_LINKS);
                } else {
                    Files.setAttribute(path, "posix:permissions", perms, new LinkOption[0]);
                }
            } else {
                this.setModeNoPosix(f, mode, umask);
            }
        }
        catch (FileSystemException fe) {
            throw new OSException(-1, fe, origPath);
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), ioe, origPath);
        }
    }

    @Override
    public void chown(File file, String origPath, String uid, String gid, boolean noFollow) throws OSException {
        if (log.isDebugEnabled()) {
            log.debug("chown({}) to {}:{}", new Object[]{origPath, uid, gid});
        }
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        try {
            UserPrincipal user = lookupService.lookupPrincipalByName(uid);
            Path path = Paths.get(file.getPath(), new String[0]);
            if (Platform.get().isPosixFilesystem()) {
                GroupPrincipal group = lookupService.lookupPrincipalByGroupName(gid);
                if (noFollow) {
                    Files.setAttribute(path, "posix:owner", user, LinkOption.NOFOLLOW_LINKS);
                    Files.setAttribute(path, "posix:group", group, LinkOption.NOFOLLOW_LINKS);
                } else {
                    Files.setAttribute(path, "posix:owner", user, new LinkOption[0]);
                    Files.setAttribute(path, "posix:group", group, new LinkOption[0]);
                }
            } else {
                Files.setOwner(path, user);
            }
        }
        catch (FileSystemException fe) {
            throw new OSException(-1, fe, origPath);
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), ioe, origPath);
        }
    }

    @Override
    public void link(File targetFile, String targetPath, File linkFile, String linkPath) throws OSException {
        Path link = Paths.get(linkFile.getPath(), new String[0]);
        Path target = Paths.get(targetFile.getPath(), new String[0]);
        try {
            if (log.isDebugEnabled()) {
                log.debug("link from {} to {}", (Object)link, (Object)target);
            }
            Files.createLink(link, target);
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), ioe, linkPath);
        }
    }

    @Override
    public void symlink(File destFile, String destPath, File srcFile, String srcPath) throws OSException {
        if (destFile == null) {
            throw new OSException(-1, "Attempt to link file above filesystem root");
        }
        Path dest = Paths.get(destFile.getPath(), new String[0]);
        Path src = Paths.get(srcFile.getPath(), new String[0]);
        Path origSrc = Paths.get(srcPath, new String[0]);
        if (!origSrc.isAbsolute()) {
            src = origSrc;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("symlink from {} to {}", (Object)src, (Object)dest);
            }
            Files.createSymbolicLink(dest, src, new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new OSException(this.getErrorCode(ioe), ioe, destPath);
        }
    }

    @Override
    public String readlink(File file, String origPath) throws OSException {
        Path path = Paths.get(file.getPath(), new String[0]);
        try {
            Path target = Files.readSymbolicLink(path);
            if (log.isDebugEnabled()) {
                log.debug("readLink({}) = {}", (Object)path, (Object)target);
            }
            if (Files.isDirectory(target, new LinkOption[0])) {
                return target.toString() + '/';
            }
            return target.toString();
        }
        catch (IOException ioe) {
            log.debug("IOException: {}", (Throwable)ioe);
            throw new OSException(this.getErrorCode(ioe), ioe, origPath);
        }
    }

    private Set<PosixFilePermission> modeToPerms(int origMode, int umask, boolean onCreate) {
        int mode = onCreate ? origMode & ~umask : origMode;
        EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (log.isTraceEnabled()) {
            log.trace("Mode {} and {} becomes {} then {}", new Object[]{Integer.toOctalString(origMode), Integer.toOctalString(umask), Integer.toOctalString(mode), perms});
        }
        return perms;
    }

    private void setModeNoPosix(File f, int origMode, int umask) {
        int mode = origMode & ~umask;
        if ((mode & 4) != 0 || (mode & 0x20) != 0) {
            f.setReadable(true, false);
        } else if ((mode & 0x100) != 0) {
            f.setReadable(true, true);
        } else {
            f.setReadable(false, true);
        }
        if ((mode & 2) != 0 || (mode & 0x10) != 0) {
            f.setWritable(true, false);
        } else if ((mode & 0x80) != 0) {
            f.setWritable(true, true);
        } else {
            f.setWritable(false, true);
        }
        if ((mode & 1) != 0 || (mode & 8) != 0) {
            f.setExecutable(true, false);
        } else if ((mode & 0x40) != 0) {
            f.setExecutable(true, true);
        } else {
            f.setExecutable(false, true);
        }
    }

    private int getErrorCode(IOException ioe) {
        String msg = ioe.getMessage();
        int code = -5;
        if (ioe instanceof FileNotFoundException) {
            code = -2;
        } else if (ioe instanceof AccessDeniedException) {
            code = -1;
        } else if (ioe instanceof DirectoryNotEmptyException) {
            code = -66;
        } else if (ioe instanceof FileAlreadyExistsException) {
            code = -17;
        } else if (ioe instanceof NoSuchFileException) {
            code = -2;
        } else if (ioe instanceof NotDirectoryException || NOT_DIRECTORY_MSG.matcher(msg).matches()) {
            code = -20;
        } else if (ioe instanceof NotLinkException) {
            code = -22;
        }
        if (log.isDebugEnabled()) {
            log.debug("File system error {} = code {}", (Object)ioe, (Object)code);
        }
        return code;
    }
}

