/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.dns;

import io.apigee.trireme.kernel.dns.Compressor;
import io.apigee.trireme.kernel.dns.DNSFormatException;
import io.apigee.trireme.kernel.dns.Decompressor;
import io.apigee.trireme.kernel.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wire {
    public static final int MAX_LABEL_LEN = 63;
    public static final int POINTER_FLAG = 49152;
    public static final int POINTER_BYTE_FLAG = 192;
    public static final int POINTER_MASK = 16383;
    public static final int POINTER_BYTE_MASK = 63;
    private static final int INIT_SIZE = 2;
    private final Header header = new Header();
    private Question question;
    private ArrayList<RR> answers = new ArrayList();

    public Header getHeader() {
        return this.header;
    }

    public void setQuestion(Question q) {
        this.question = q;
    }

    public Question getQuestion() {
        return this.question;
    }

    public void addAnswer(RR answer) {
        this.answers.add(answer);
    }

    public List<RR> getAnswers() {
        return this.answers;
    }

    public ByteBuffer store() throws DNSFormatException {
        this.header.setQuestionCount(this.question == null ? 0 : 1);
        this.header.setAnswerCount(this.answers.size());
        this.header.setNsCount(0);
        this.header.setArCount(0);
        Compressor comp = new Compressor();
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb = this.header.store(bb);
        if (this.question != null) {
            bb = this.question.store(bb, comp);
        }
        for (RR answer : this.answers) {
            bb = answer.store(bb, comp);
        }
        bb.flip();
        return bb;
    }

    public void load(ByteBuffer bb) throws DNSFormatException {
        Decompressor dcomp = new Decompressor();
        this.header.load(bb);
        if (this.header.questionCount > 0) {
            this.question = new Question();
            this.question.load(bb, dcomp);
        }
        for (int i = 0; i < this.header.answerCount; ++i) {
            RR answer = new RR();
            answer.load(bb, dcomp);
            this.answers.add(answer);
        }
    }

    public static class RR {
        private String name;
        private int type;
        private int klass;
        private long ttl;
        private int length;
        private ByteBuffer data;
        private Object result;

        ByteBuffer store(ByteBuffer b, Compressor comp) throws DNSFormatException {
            ByteBuffer bb = comp.writeName(b, this.name);
            while (bb.remaining() < 10) {
                bb = BufferUtils.doubleBuffer(bb);
            }
            bb.putShort((short)this.type);
            bb.putShort((short)this.klass);
            bb.putInt((int)this.ttl);
            bb.putShort((short)this.length);
            while (bb.remaining() < this.data.remaining()) {
                bb = BufferUtils.doubleBuffer(bb);
            }
            ByteBuffer tmpData = this.data.duplicate();
            bb.put(tmpData);
            return bb;
        }

        void load(ByteBuffer bb, Decompressor dcomp) throws DNSFormatException {
            this.name = dcomp.readName(bb);
            this.type = bb.getShort() & 0xFFFF;
            this.klass = bb.getShort() & 0xFFFF;
            this.ttl = (long)bb.getInt() & 0xFFFFFFFFL;
            this.length = bb.getShort() & 0xFFFF;
            if (bb.remaining() < this.length) {
                throw new DNSFormatException("Invalid DNS record.");
            }
            this.data = bb.duplicate();
            this.data.limit(this.data.position() + this.length);
            bb.position(bb.position() + this.length);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getKlass() {
            return this.klass;
        }

        public void setKlass(int klass) {
            this.klass = klass;
        }

        public long getTtl() {
            return this.ttl;
        }

        public void setTtl(long ttl) {
            this.ttl = ttl;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public ByteBuffer getData() {
            return this.data;
        }

        public void setData(ByteBuffer data) {
            this.data = data;
            this.length = data.remaining();
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object r) {
            this.result = r;
        }
    }

    public static class Question {
        private String name;
        private int klass;
        private int type;

        ByteBuffer store(ByteBuffer b, Compressor comp) throws DNSFormatException {
            ByteBuffer bb = b;
            bb = comp.writeName(bb, this.name);
            while (bb.remaining() < 4) {
                bb = BufferUtils.doubleBuffer(bb);
            }
            bb.putShort((short)this.type);
            bb.putShort((short)this.klass);
            return bb;
        }

        void load(ByteBuffer bb, Decompressor dcomp) throws DNSFormatException {
            this.name = dcomp.readName(bb);
            this.type = bb.getShort() & 0xFFFF;
            this.klass = bb.getShort() & 0xFFFF;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getKlass() {
            return this.klass;
        }

        public void setKlass(int klass) {
            this.klass = klass;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }

    public static class Header {
        private int id;
        private boolean response;
        private int opcode;
        private boolean authoritative;
        private boolean truncated;
        private boolean recursionDesired;
        private boolean recursionAvailable;
        private int rcode;
        private int questionCount;
        private int answerCount;
        private int nsCount;
        private int arCount;

        ByteBuffer store(ByteBuffer b) {
            ByteBuffer bb = b;
            while (bb.remaining() < 12) {
                bb = BufferUtils.doubleBuffer(bb);
            }
            bb.putShort((short)this.id);
            int byte3 = (this.opcode & 0xF) << 3;
            if (this.response) {
                byte3 |= 0x80;
            }
            if (this.authoritative) {
                byte3 |= 4;
            }
            if (this.truncated) {
                byte3 |= 2;
            }
            if (this.recursionDesired) {
                byte3 |= 1;
            }
            bb.put((byte)byte3);
            int byte4 = this.rcode & 0xF;
            if (this.recursionAvailable) {
                byte4 |= 0x80;
            }
            bb.put((byte)byte4);
            bb.putShort((short)this.questionCount);
            bb.putShort((short)this.answerCount);
            bb.putShort((short)this.nsCount);
            bb.putShort((short)this.arCount);
            return bb;
        }

        void load(ByteBuffer bb) throws DNSFormatException {
            int byte4;
            if (bb.remaining() < 12) {
                throw new DNSFormatException("Incomplete DNS header");
            }
            this.id = bb.getShort() & 0xFFFF;
            int byte3 = bb.get() & 0xFF;
            if ((byte3 & 0x80) != 0) {
                this.response = true;
            }
            this.opcode = byte3 >> 3 & 0xF;
            if ((byte3 & 4) != 0) {
                this.authoritative = true;
            }
            if ((byte3 & 2) != 0) {
                this.truncated = true;
            }
            if ((byte3 & 1) != 0) {
                this.recursionDesired = true;
            }
            if (((byte4 = bb.get() & 0xFF) & 0x80) != 0) {
                this.recursionAvailable = true;
            }
            this.rcode = byte4 & 0xF;
            this.questionCount = bb.getShort() & 0xFFFF;
            this.answerCount = bb.getShort() & 0xFFFF;
            this.nsCount = bb.getShort() & 0xFFFF;
            this.arCount = bb.getShort() & 0xFFFF;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public boolean isResponse() {
            return this.response;
        }

        public void setResponse(boolean response) {
            this.response = response;
        }

        public int getOpcode() {
            return this.opcode;
        }

        public void setOpcode(int opcode) {
            this.opcode = opcode;
        }

        public boolean isAuthoritative() {
            return this.authoritative;
        }

        public void setAuthoritative(boolean authoritative) {
            this.authoritative = authoritative;
        }

        public boolean isTruncated() {
            return this.truncated;
        }

        public void setTruncated(boolean truncated) {
            this.truncated = truncated;
        }

        public boolean isRecursionDesired() {
            return this.recursionDesired;
        }

        public void setRecursionDesired(boolean recursionDesired) {
            this.recursionDesired = recursionDesired;
        }

        public boolean isRecursionAvailable() {
            return this.recursionAvailable;
        }

        public void setRecursionAvailable(boolean recursionAvailable) {
            this.recursionAvailable = recursionAvailable;
        }

        public int getRcode() {
            return this.rcode;
        }

        public void setRcode(int rcode) {
            this.rcode = rcode;
        }

        public int getQuestionCount() {
            return this.questionCount;
        }

        public void setQuestionCount(int questionCount) {
            this.questionCount = questionCount;
        }

        public int getAnswerCount() {
            return this.answerCount;
        }

        public void setAnswerCount(int answerCount) {
            this.answerCount = answerCount;
        }

        public int getNsCount() {
            return this.nsCount;
        }

        public void setNsCount(int nsCount) {
            this.nsCount = nsCount;
        }

        public int getArCount() {
            return this.arCount;
        }

        public void setArCount(int arCount) {
            this.arCount = arCount;
        }
    }
}

