/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.dns;

import io.apigee.trireme.kernel.dns.DNSFormatException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import sun.net.util.IPAddressUtil;

public class Reverser {
    public static final String IP4_SUFFIX = "IN-ADDR.ARPA";
    public static final String IP6_SUFFIX = "IP6.ARPA";
    private static final Pattern DOT = Pattern.compile("\\.");

    public static String reverse(String address) throws DNSFormatException {
        if (IPAddressUtil.isIPv4LiteralAddress(address)) {
            try {
                return Reverser.reverse4(address, (Inet4Address)InetAddress.getByName(address));
            }
            catch (UnknownHostException uhe) {
                throw new AssertionError((Object)"Invalid IP address");
            }
        }
        if (IPAddressUtil.isIPv6LiteralAddress(address)) {
            try {
                return Reverser.reverse6((Inet6Address)InetAddress.getByName(address));
            }
            catch (UnknownHostException uhe) {
                throw new AssertionError((Object)"Invalid IP address");
            }
        }
        throw new DNSFormatException("Invalid IP address: " + address);
    }

    private static String reverse4(String str, Inet4Address a) {
        byte[] addr = a.getAddress();
        StringBuilder sb = new StringBuilder();
        assert (addr.length == 4);
        int numDots = DOT.split(str).length;
        switch (numDots) {
            case 4: {
                Reverser.appendByte4(addr[3], sb);
                Reverser.appendByte4(addr[2], sb);
                Reverser.appendByte4(addr[1], sb);
                Reverser.appendByte4(addr[0], sb);
                break;
            }
            case 3: {
                Reverser.appendByte4(addr[3], sb);
                Reverser.appendByte4(addr[1], sb);
                Reverser.appendByte4(addr[0], sb);
                break;
            }
            case 2: {
                Reverser.appendByte4(addr[3], sb);
                Reverser.appendByte4(addr[0], sb);
                break;
            }
            case 1: {
                Reverser.appendByte4(addr[3], sb);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        sb.append(IP4_SUFFIX);
        return sb.toString();
    }

    private static void appendByte4(byte b, StringBuilder sb) {
        int bi = b & 0xFF;
        sb.append((Object)bi);
        sb.append('.');
    }

    private static String reverse6(Inet6Address a) {
        byte[] addr = a.getAddress();
        StringBuilder sb = new StringBuilder();
        for (int i = addr.length - 1; i >= 0; --i) {
            Reverser.appendByte6(addr[i], sb);
        }
        sb.append(IP6_SUFFIX);
        return sb.toString();
    }

    private static void appendByte6(byte b, StringBuilder sb) {
        int low = b & 0xF;
        sb.append(Integer.toHexString(low));
        sb.append('.');
        int hi = (b & 0xF0) >> 4;
        sb.append(Integer.toHexString(hi));
        sb.append('.');
    }
}

