/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.dns;

import io.apigee.trireme.kernel.dns.DNSFormatException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class Decompressor {
    private static final Charset ASCII = Charset.forName("ascii");
    private ByteBuffer readBuf;

    public String readName(ByteBuffer bb) throws DNSFormatException {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        this.readBuf = bb;
        String label;
        while ((label = this.readLabel()) != null) {
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append(label);
        }
        return sb.toString();
    }

    private String readLabel() throws DNSFormatException {
        if (!this.readBuf.hasRemaining()) {
            throw new DNSFormatException("Premature EOM while reading label");
        }
        int mark = this.readBuf.get() & 0xFF;
        if ((mark & 0xC0) == 192) {
            int offset = (mark & 0x3F) << 8 | this.readBuf.get() & 0xFF;
            if (offset < 0 || offset > this.readBuf.limit()) {
                throw new DNSFormatException("Invalid offset while reading label");
            }
            this.readBuf = this.readBuf.duplicate();
            this.readBuf.position(offset);
            return this.readLabel();
        }
        int len = mark;
        if (len > this.readBuf.remaining()) {
            throw new DNSFormatException("Premature EOM while reading label text");
        }
        if (len == 0) {
            return null;
        }
        return this.readString(this.readBuf, len);
    }

    public String readCharacterString(ByteBuffer buf) {
        int len = buf.get() & 0xFF;
        if (len == 0) {
            return "";
        }
        return this.readString(buf, len);
    }

    private String readString(ByteBuffer buf, int len) {
        if (buf.hasArray()) {
            String s = new String(buf.array(), buf.arrayOffset() + buf.position(), len, ASCII);
            buf.position(buf.position() + len);
            return s;
        }
        byte[] tmp = new byte[len];
        buf.get(tmp);
        return new String(tmp, ASCII);
    }
}

