/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.dns;

import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.dns.DNSConfig;
import io.apigee.trireme.kernel.dns.DNSException;
import io.apigee.trireme.kernel.dns.DNSFormatException;
import io.apigee.trireme.kernel.dns.Reverser;
import io.apigee.trireme.kernel.dns.Types;
import io.apigee.trireme.kernel.dns.Wire;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import io.apigee.trireme.kernel.handles.NIODatagramHandle;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSResolver {
    protected static final Logger log = LoggerFactory.getLogger(DNSResolver.class);
    public static final int DNS_PORT = 53;
    protected static final int[] TIMEOUTS = new int[]{5, 5, 5, -1};
    protected static final SecureRandom rand = new SecureRandom();
    protected final GenericNodeRuntime runtime;

    public DNSResolver(GenericNodeRuntime runtime) {
        this.runtime = runtime;
    }

    public void resolve(String name, String type, IOCompletionHandler<Wire> onComplete) throws OSException {
        ByteBuffer queryBuf;
        Wire query;
        DNSConfig config = DNSConfig.get();
        if (config.getServers().isEmpty()) {
            throw new OSException(-22, "No DNS servers configured");
        }
        try {
            query = this.makeQuery(name, type);
            queryBuf = query.store();
        }
        catch (DNSException de) {
            throw new OSException(-22, "Invalid DNS query");
        }
        QueryStatus q = new QueryStatus(query, queryBuf, onComplete);
        q.send(TIMEOUTS[0]);
    }

    private Wire makeQuery(String n, String type) throws DNSException, OSException {
        String name;
        int typeCode = Types.get().getTypeCode(type);
        if (typeCode < 0) {
            throw new DNSFormatException("Invalid type code " + type);
        }
        if (typeCode == 12) {
            try {
                name = Reverser.reverse(n);
            }
            catch (DNSFormatException dfe) {
                throw new OSException(-200);
            }
        } else {
            name = n;
        }
        Wire msg = new Wire();
        Wire.Header hdr = msg.getHeader();
        Wire.Question q = new Wire.Question();
        msg.setQuestion(q);
        q.setName(name);
        q.setType(typeCode);
        q.setKlass(1);
        hdr.setId(rand.nextInt(65536));
        hdr.setRecursionDesired(true);
        hdr.setOpcode(0);
        return msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryStatus {
        private final Wire query;
        private final ByteBuffer queryBuf;
        private final IOCompletionHandler<Wire> onComplete;
        private int tryCount;
        private boolean gotResult;

        QueryStatus(Wire query, ByteBuffer queryBuf, IOCompletionHandler<Wire> onComplete) {
            this.query = query;
            this.queryBuf = queryBuf;
            this.onComplete = onComplete;
        }

        void send(final int timeout) {
            String server = this.getServer();
            if (log.isDebugEnabled()) {
                log.debug("Sending {} query to {}", (Object)this.query.getQuestion().getType(), (Object)server);
            }
            final NIODatagramHandle dgHandle = new NIODatagramHandle(DNSResolver.this.runtime);
            try {
                dgHandle.bind(null, 0);
                dgHandle.send(server, 53, this.queryBuf.duplicate(), new IOCompletionHandler<Integer>(){

                    @Override
                    public void ioComplete(int errCode, Integer value) {
                        QueryStatus.this.handleSendComplete(errCode, timeout, dgHandle);
                    }
                });
            }
            catch (OSException ose) {
                if (log.isDebugEnabled()) {
                    log.debug("Error on send: {}", (Throwable)ose);
                }
                this.onComplete.ioComplete(ose.getCode(), null);
            }
        }

        private String getServer() {
            DNSConfig config = DNSConfig.get();
            int sn = this.tryCount % config.getServers().size();
            return config.getServers().get(sn);
        }

        private void handleSendComplete(int errCode, int timeout, final NIODatagramHandle dgHandle) {
            if (errCode == 0) {
                final Future<Boolean> timer = DNSResolver.this.runtime.createTimedTask(new Runnable(){

                    public void run() {
                        dgHandle.close();
                        if (!QueryStatus.this.gotResult) {
                            log.debug("DNS query timed out");
                            QueryStatus.this.handleRetry(-201);
                        }
                    }
                }, timeout, TimeUnit.SECONDS, false, null);
                dgHandle.startReadingDatagrams(new IOCompletionHandler<NIODatagramHandle.ReceivedDatagram>(){

                    @Override
                    public void ioComplete(int errCode, NIODatagramHandle.ReceivedDatagram value) {
                        if (QueryStatus.this.gotResult) {
                            log.debug("Discarding duplicate DNS result!");
                            return;
                        }
                        timer.cancel(false);
                        QueryStatus.this.gotResult = true;
                        QueryStatus.this.handleReceivedPacket(errCode, value, dgHandle);
                    }
                });
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Error code {} on send", (Object)errCode);
                }
                this.handleRetry(errCode);
            }
        }

        private void handleReceivedPacket(int errCode, NIODatagramHandle.ReceivedDatagram msg, NIODatagramHandle dgHandle) {
            dgHandle.stopReading();
            dgHandle.close();
            if (errCode == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Got back {} bytes", (Object)msg.getBuffer().remaining());
                }
                try {
                    Wire dnsMsg = new Wire();
                    dnsMsg.load(msg.getBuffer());
                    switch (dnsMsg.getHeader().getRcode()) {
                        case 0: {
                            this.handleSuccessfulResponse(dnsMsg);
                            break;
                        }
                        case 1: {
                            this.onComplete.ioComplete(-202, null);
                            break;
                        }
                        case 2: {
                            this.onComplete.ioComplete(-205, null);
                            break;
                        }
                        case 4: {
                            this.onComplete.ioComplete(-200, null);
                            break;
                        }
                        case 5: {
                            this.onComplete.ioComplete(-203, null);
                            break;
                        }
                        default: {
                            this.onComplete.ioComplete(-5, null);
                            break;
                        }
                    }
                }
                catch (DNSFormatException de) {
                    this.onComplete.ioComplete(-204, null);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Error code {} on receive", (Object)errCode);
                }
                this.handleRetry(errCode);
            }
        }

        private void handleSuccessfulResponse(Wire msg) {
            if (this.query.getHeader().getId() != msg.getHeader().getId()) {
                this.onComplete.ioComplete(-204, null);
                return;
            }
            try {
                for (Wire.RR rr : msg.getAnswers()) {
                    Types.get().parseRecord(rr);
                }
                this.onComplete.ioComplete(0, msg);
            }
            catch (DNSFormatException de) {
                this.onComplete.ioComplete(-204, null);
            }
        }

        private void handleRetry(int errCode) {
            ++this.tryCount;
            if (TIMEOUTS[this.tryCount] > 0) {
                this.send(TIMEOUTS[this.tryCount]);
            } else {
                this.onComplete.ioComplete(errCode, null);
            }
        }
    }
}

