/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.dns;

import io.apigee.trireme.kernel.dns.DNSFormatException;
import io.apigee.trireme.kernel.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;

public class Compressor {
    private static final Charset ASCII = Charset.forName("ascii");
    private final HashMap<String, Integer> state = new HashMap();

    public boolean writeLabel(ByteBuffer bb, String label) throws DNSFormatException {
        byte[] la = label.getBytes(ASCII);
        if (la.length > 63) {
            throw new DNSFormatException("Label too long");
        }
        if (la.length + 1 > bb.remaining()) {
            return false;
        }
        bb.put((byte)la.length);
        bb.put(la);
        return true;
    }

    private boolean writePointer(ByteBuffer bb, int pos) {
        if (bb.remaining() < 2) {
            return false;
        }
        int ptr = (pos & 0x3FFF | 0xC000) & 0xFFFF;
        bb.putShort((short)ptr);
        return true;
    }

    public ByteBuffer writeName(ByteBuffer b, String name) throws DNSFormatException {
        ByteBuffer bb = b;
        Integer ptr = this.state.get(name);
        if (ptr == null) {
            String label;
            this.state.put(name, bb.position());
            int dot = name.indexOf(46);
            String string = label = dot < 0 ? name : name.substring(0, dot);
            while (!this.writeLabel(bb, label)) {
                bb = BufferUtils.doubleBuffer(bb);
            }
            if (dot >= 0 && name.length() > dot + 1) {
                return this.writeName(bb, name.substring(dot + 1));
            }
            while (!bb.hasRemaining()) {
                bb = BufferUtils.doubleBuffer(bb);
            }
            bb.put((byte)0);
            return bb;
        }
        while (!this.writePointer(bb, ptr)) {
            bb = BufferUtils.doubleBuffer(bb);
        }
        return bb;
    }
}

