/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel.crypto;

import io.apigee.trireme.kernel.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLCiphers {
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";
    private static final Pattern COLON = Pattern.compile(":");
    private static final Pattern WHITESPACE = Pattern.compile("[\\t ]+");
    private static final SSLCiphers myself = new SSLCiphers();
    private final ArrayList<Ciph> cipherInfo = new ArrayList();
    private final String[] defaultCipherList;
    private final HashSet<String> defaultCiphers;
    private final String[] allCipherList;
    private final LinkedHashMap<String, Ciph> allCiphers;

    public static SSLCiphers get() {
        return myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLCiphers() {
        try {
            SSLEngine engine = SSLContext.getDefault().createSSLEngine();
            this.defaultCipherList = engine.getEnabledCipherSuites();
            this.defaultCiphers = new HashSet<String>(Arrays.asList(this.defaultCipherList));
            this.allCipherList = engine.getSupportedCipherSuites();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        HashMap<String, Ciph> javaCiphers = new HashMap<String, Ciph>();
        try {
            BufferedReader rdr = new BufferedReader(new InputStreamReader(SSLCiphers.class.getResourceAsStream("/ssl-ciphers.txt"), Charsets.UTF8));
            try {
                String line;
                do {
                    String[] m;
                    if ((line = rdr.readLine()) == null || line.startsWith("#") || (m = WHITESPACE.split(line)).length != 6) continue;
                    Ciph c = new Ciph();
                    c.setJavaName(m[0]);
                    c.setSslName(m[1]);
                    c.setProtocol(m[2]);
                    c.setKeyAlg(m[3]);
                    c.setCryptAlg(m[4]);
                    c.setKeyLen(Integer.parseInt(m[5]));
                    javaCiphers.put(c.getJavaName(), c);
                    this.cipherInfo.add(c);
                } while (line != null);
            }
            finally {
                rdr.close();
            }
        }
        catch (IOException ioe) {
            throw new AssertionError("Can't read SSL ciphers file", ioe);
        }
        catch (NumberFormatException nfe) {
            throw new AssertionError("Invalid line in SSL ciphers file", nfe);
        }
        this.allCiphers = new LinkedHashMap(this.allCipherList.length);
        for (String cn : this.allCipherList) {
            Ciph c = (Ciph)javaCiphers.get(cn);
            if (c == null) continue;
            this.allCiphers.put(cn, c);
        }
    }

    public Ciph getJavaCipher(String name) {
        return this.allCiphers.get(name);
    }

    public String[] filterCipherList(String filter) {
        LinkedHashMap<String, Ciph> ciphers = new LinkedHashMap<String, Ciph>();
        ArrayList<String> exclusions = new ArrayList<String>();
        for (String exp : COLON.split(filter)) {
            if (exp.startsWith("-")) {
                this.removeMatches(ciphers, exp.substring(1));
                continue;
            }
            if (exp.startsWith("!")) {
                exclusions.add(exp.substring(1));
                this.removeMatches(ciphers, exp.substring(1));
                continue;
            }
            if (exp.startsWith("+")) {
                this.moveMatchesToEnd(ciphers, exclusions, exp.substring(1));
                continue;
            }
            this.appendMatches(ciphers, exclusions, exp);
        }
        return ciphers.keySet().toArray(new String[ciphers.size()]);
    }

    private boolean excluded(Ciph c, List<String> exclusions) {
        for (String exp : exclusions) {
            if (this.matches(c, exp)) continue;
            return true;
        }
        return false;
    }

    private void removeMatches(Map<String, Ciph> ciphers, String exp) {
        for (Ciph c : this.allCiphers.values()) {
            if (!this.matches(c, exp)) continue;
            ciphers.remove(c.getJavaName());
        }
    }

    private void appendMatches(Map<String, Ciph> ciphers, List<String> exclusions, String exp) {
        for (Ciph c : this.allCiphers.values()) {
            if (!this.matches(c, exp) || this.excluded(c, exclusions) || ciphers.containsKey(c.getJavaName())) continue;
            ciphers.put(c.getJavaName(), c);
        }
    }

    private void moveMatchesToEnd(Map<String, Ciph> ciphers, List<String> exclusions, String exp) {
        for (Ciph c : this.allCiphers.values()) {
            if (!this.matches(c, exp) || this.excluded(c, exclusions)) continue;
            ciphers.remove(c.getJavaName());
            ciphers.put(c.getJavaName(), c);
        }
    }

    private boolean matches(Ciph c, String exp) {
        if ("DEFAULT".equals(exp)) {
            return this.defaultCiphers.contains(c.getJavaName());
        }
        if ("COMPLEMENTOFDEFAULT".equals(exp)) {
            return !this.defaultCiphers.contains(c.getJavaName());
        }
        if ("ALL".equals(exp)) {
            return true;
        }
        if ("HIGH".equals(exp)) {
            return c.getKeyLen() >= 128;
        }
        if ("MEDIUM".equals(exp)) {
            return c.getKeyLen() == 128;
        }
        if ("LOW".equals(exp)) {
            return c.getKeyLen() < 128 && c.getKeyLen() >= 56;
        }
        if ("EXP".equals(exp) || "EXPORT".equals(exp)) {
            return c.getKeyLen() < 56;
        }
        if ("EXPORT40".equals(exp)) {
            return c.getKeyLen() == 40;
        }
        if ("EXPORT56".equals(exp)) {
            return c.getKeyLen() == 56;
        }
        if ("eNULL".equals(exp) || "NULL".equals(exp)) {
            return "NULL".equals(c.getCryptAlg());
        }
        if ("aNULL".equals(exp)) {
            return "NULL".equals(c.getKeyAlg());
        }
        if ("kRSA".equals(exp) || "RSA".equals(exp)) {
            return "RSA".equals(c.getKeyAlg());
        }
        if ("kEDH".equals(exp)) {
            return "ECDH".equals(c.getKeyAlg()) || "ECDHE".equals(c.getKeyAlg());
        }
        if ("DH".equals(exp)) {
            return "DH".equals(c.getKeyAlg());
        }
        if ("ADH".equals(exp)) {
            return "ADH".equals(c.getKeyAlg());
        }
        if ("AES".equals(exp)) {
            return "AES".equals(c.getCryptAlg());
        }
        if ("DES".equals(exp)) {
            return "DES".equals(c.getCryptAlg()) && c.getKeyLen() <= 56;
        }
        if ("3DES".equals(exp)) {
            return "DES".equals(c.getCryptAlg()) && c.getKeyLen() == 168;
        }
        if ("RC4".equals(exp)) {
            return "RC4".equals(c.getCryptAlg());
        }
        if ("RC2".equals(exp)) {
            return "RC2".equals(c.getCryptAlg());
        }
        if ("MD5".equals(exp)) {
            return c.getJavaName().contains("MD5");
        }
        return exp.equals(c.getSslName());
    }

    public static final class Ciph {
        private String protocol;
        private String javaName;
        private String sslName;
        private String keyAlg;
        private String cryptAlg;
        private int keyLen;

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getJavaName() {
            return this.javaName;
        }

        public void setJavaName(String javaName) {
            this.javaName = javaName;
        }

        public String getSslName() {
            return this.sslName;
        }

        public void setSslName(String sslName) {
            this.sslName = sslName;
        }

        public String getKeyAlg() {
            return this.keyAlg;
        }

        public void setKeyAlg(String keyAlg) {
            this.keyAlg = keyAlg;
        }

        public String getCryptAlg() {
            return this.cryptAlg;
        }

        public void setCryptAlg(String cryptAlg) {
            this.cryptAlg = cryptAlg;
        }

        public int getKeyLen() {
            return this.keyLen;
        }

        public void setKeyLen(int keyLen) {
            this.keyLen = keyLen;
        }
    }
}

