/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel;

import io.apigee.trireme.kernel.NodeVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionMatcher<T> {
    private final ArrayList<NodeVersion<T>> versions = new ArrayList();
    private boolean sorted;

    public void add(NodeVersion<T> v) {
        this.versions.add(v);
        this.sorted = false;
    }

    public T match(String vs) {
        if (!this.sorted) {
            this.sortVersions();
        }
        NodeVersion mv = new NodeVersion(vs);
        for (NodeVersion<T> v : this.versions) {
            if (!mv.equals(v)) continue;
            return v.getAttachment();
        }
        return null;
    }

    private void sortVersions() {
        Collections.sort(this.versions, Collections.reverseOrder());
        this.sorted = true;
    }

    public List<T> getVersions() {
        ArrayList<T> a = new ArrayList<T>();
        for (NodeVersion<T> v : this.versions) {
            a.add(v.getAttachment());
        }
        return a;
    }
}

