/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTranslator {
    private static final Logger log = LoggerFactory.getLogger((String)PathTranslator.class.getName());
    private static final Pattern separator = Pattern.compile("\\" + File.separatorChar);
    private static final Pattern windowsRoot = Pattern.compile("^[A-Za-z]:.*$");
    private static final boolean caseSensitive = !new File("a").equals(new File("A"));
    private File root;
    private String canonicalRoot;
    private File workingDir;
    private List<Map.Entry<String, File>> mounts = Collections.emptyList();

    public PathTranslator() {
        this.root = null;
        this.canonicalRoot = null;
    }

    public PathTranslator(String root) throws IOException {
        this.setRoot(root);
    }

    public void setWorkingDir(String wd) {
        this.workingDir = new File(wd);
    }

    public void setRoot(String root) throws IOException {
        this.root = new File(root);
        this.canonicalRoot = this.root.getCanonicalPath();
    }

    public String getRoot() {
        return this.root == null ? null : this.root.getPath();
    }

    public void mount(String prefix, File path) {
        if (this.mounts.isEmpty()) {
            this.mounts = new ArrayList<Map.Entry<String, File>>();
        }
        this.mounts.add(new AbstractMap.SimpleEntry<String, File>(prefix, path));
    }

    public File translate(String pathStr) {
        File path;
        if (pathStr.startsWith("\\\\?\\")) {
            pathStr = pathStr.substring(4);
        }
        if (!(path = new File(pathStr)).isAbsolute() && !windowsRoot.matcher(pathStr).matches()) {
            path = new File(this.workingDir, pathStr);
        }
        for (Map.Entry<String, File> mount : this.mounts) {
            if (!PathTranslator.startsWithFS(path.getPath(), mount.getKey())) continue;
            String remaining = path.getPath().length() == mount.getKey().length() ? "." : path.getPath().substring(mount.getKey().length());
            return new File(mount.getValue(), remaining);
        }
        if (this.root == null) {
            if (log.isTraceEnabled()) {
                log.trace("translate: {} -> {}", (Object)pathStr, (Object)path.getPath());
            }
            return path;
        }
        String[] components = separator.split(path.getPath());
        int depth = 0;
        for (String c : components) {
            if ("..".equals(c)) {
                --depth;
                continue;
            }
            if (".".equals(c) || c.isEmpty()) continue;
            ++depth;
        }
        if (depth < 0) {
            if (log.isDebugEnabled()) {
                log.debug("PathTranslator: {} tries to escape root", (Object)path);
            }
            return null;
        }
        File realPath = new File(this.root, path.getPath());
        if (log.isDebugEnabled()) {
            log.debug("translate: {} -> {}", (Object)path, (Object)realPath.getPath());
        }
        return realPath;
    }

    public String reverseTranslate(String path) throws IOException {
        if (!this.mounts.isEmpty()) {
            String mountRoot = null;
            String mountPath = path;
            for (Map.Entry<String, File> mount : this.mounts) {
                String remaining;
                String realMount = mount.getValue().getPath();
                if (!PathTranslator.startsWithFS(path, realMount) || (remaining = path.substring(realMount.length())).length() >= mountPath.length()) continue;
                mountRoot = mount.getKey();
                mountPath = remaining;
            }
            if (mountRoot != null) {
                return mountRoot + mountPath;
            }
        }
        if (this.root == null) {
            return path;
        }
        String canon = new File(path).getCanonicalPath();
        String realPath = canon.length() < this.canonicalRoot.length() ? null : (canon.length() == this.canonicalRoot.length() ? File.separator : canon.substring(this.canonicalRoot.length()));
        if (log.isDebugEnabled()) {
            log.debug("PathTranslator.reverse: {} -> {}", (Object)path, (Object)realPath);
        }
        return realPath;
    }

    private static boolean startsWithFS(String path, String prefix) {
        return caseSensitive ? path.startsWith(prefix) : path.length() >= prefix.length() && prefix.equalsIgnoreCase(path.substring(0, prefix.length()));
    }
}

