/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorCodes {
    private static final ErrorCodes myself = new ErrorCodes();
    private final HashMap<String, Integer> stringCodes = new HashMap();
    private final HashMap<Integer, String> numCodes = new HashMap();
    public static final int EACCES = -13;
    public static final int EADDRINUSE = -48;
    public static final int EAGAIN = -35;
    public static final int ECONNREFUSED = -61;
    public static final int EBADF = -9;
    public static final int EINTR = -4;
    public static final int EEXIST = -17;
    public static final int EINVAL = -22;
    public static final int EIO = -5;
    public static final int EILSEQ = -92;
    public static final int EISDIR = -21;
    public static final int ENFILE = -23;
    public static final int EMFILE = -24;
    public static final int ENOTEMPTY = -66;
    public static final int ENOENT = -2;
    public static final int ENOTDIR = -20;
    public static final int EPERM = -1;
    public static final int EPIPE = -32;
    public static final int ESRCH = -3;
    public static final int EOF = -99;
    public static final int ENOTIMP = -200;
    public static final int ETIMEOUT = -201;
    public static final int ESERVFAIL = -202;
    public static final int EREFUSED = -203;
    public static final int EBADRESP = -204;
    public static final int ENOTFOUND = -205;

    public static ErrorCodes get() {
        return myself;
    }

    public String toString(int code) {
        String s = this.numCodes.get(code);
        return s == null ? "UNKNOWN" : s;
    }

    public int toInt(String code) {
        Integer i = this.stringCodes.get(code);
        return i == null ? 0 : i;
    }

    public Map<Integer, String> getMap() {
        return Collections.unmodifiableMap(this.numCodes);
    }

    private ErrorCodes() {
        this.mapCode("EACCES", -13);
        this.mapCode("EADDRINUSE", -48);
        this.mapCode("EAGAIN", -35);
        this.mapCode("ECONNREFUSED", -61);
        this.mapCode("EBADF", -9);
        this.mapCode("EINTR", -4);
        this.mapCode("EEXIST", -17);
        this.mapCode("EINVAL", -22);
        this.mapCode("EIO", -5);
        this.mapCode("EILSEQ", -92);
        this.mapCode("EISDIR", -21);
        this.mapCode("EMFILE", -24);
        this.mapCode("ENFILE", -23);
        this.mapCode("ENOTFOUND", -205);
        this.mapCode("ENOTEMPTY", -66);
        this.mapCode("ENOENT", -2);
        this.mapCode("ENOTDIR", -20);
        this.mapCode("EPERM", -1);
        this.mapCode("EPIPE", -32);
        this.mapCode("ESRCH", -3);
        this.mapCode("EOF", -99);
        this.mapCode("ENOTIMP", -200);
        this.mapCode("ETIMEOUT", -201);
        this.mapCode("ESERVFAIL", -202);
        this.mapCode("EREFUSED", -203);
        this.mapCode("EBADRESP", -204);
    }

    private void mapCode(String s, int n) {
        this.stringCodes.put(s, n);
        this.numCodes.put(n, s);
    }
}

